package com.yy.mobile.ui.widget.banner;

import android.content.Context;
import android.util.AttributeSet;

import com.yy.mobile.data.meipai.MPBannerData;

import java.util.List;

/**
 * Created by duhongzhou on 2016/1/13.
 * Object只是一个数据类，先暂时屏蔽用其他代替
 */
public class HPTopBannerGallery extends AdGallery {
    private HPTopBannerAdapter<MPBannerData> mAdapter;

    public HPTopBannerGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        mAdapter = new HPTopBannerAdapter<>(context);
    }

    public HPTopBannerGallery(Context context) {
        super(context);
        mAdapter = new HPTopBannerAdapter<>(context);
    }

    public HPTopBannerGallery(Context context, AttributeSet attrs) {
        super(context, attrs);
        mAdapter = new HPTopBannerAdapter<>(context);
    }

    public void setData(List<MPBannerData> data, int fromType) {
        this.endAutoScroll();
        mAdapter.setFromType(fromType);
        mAdapter.setData(data);
        this.setAdapter(mAdapter);
    }

    public void addData(List<MPBannerData> data) {
        this.endAutoScroll();
        mAdapter.addData(data);
        this.setAdapter(mAdapter);
        this.endAutoScroll();
    }

    public List getData() {
        return mAdapter.getData();
    }

    public Object getItemInfo(int position) {
        List<Object> infos = getData();
        if (infos.size() <= 0) {
            return null;
        }
        int index = position % infos.size();
        return infos.get(index);
    }
}
