package com.yy.mobile.ui.widget.banner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Gallery;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.data.base.HomepageData;
import com.yy.mobile.data.meipai.MPBannerData;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.utils.FP;
import com.yy.mobile.utils.ScreenUtil;

/**
 * Created by duhongzhou on 2016/1/13.
 */
public class HPTopBannerAdapter<T extends HomepageData> extends AdAdapter<T> {
    private int type;
    private int width;
    private int height;

    public HPTopBannerAdapter(Context context) {
        super(context);
        fillSize();
    }

    private void fillSize() {
        width = ScreenUtil.INSTANCE.getScreenWidth(mContext);
        height = width * 250 / 750;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = new FrameLayout(mContext);
            convertView.setLayoutParams(new Gallery.LayoutParams(width, Gallery.LayoutParams.MATCH_PARENT));
            ImageView imageView = new ImageView(mContext);
            ((FrameLayout) convertView).addView(imageView, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
            viewHolder = new ViewHolder();
            viewHolder.imageview = imageView;
            viewHolder.imageview.setScaleType(ImageView.ScaleType.CENTER_CROP);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        Object info = getItem(position);
        if (info != null) {
            String url = "";
            if (info instanceof MPBannerData && !FP.INSTANCE.empty(((MPBannerData) info).getImage())) {
                url = ((MPBannerData) info).getImage();
//                        + ((MPBannerData) info).getSuffix(width, height);
            }
            loadCorpImageWithNineBg(viewHolder.imageview, url, R.drawable.hp_mn_mobile_live_topic_default_bg);
        }
        return convertView;
    }

    public void setFromType(int fromType) {
        this.type = fromType;
    }

    @Override
    public int getCount() {
        if (mData.size() <= 1) {
            return mData.size();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public T getItem(int position) {
        if (mData.size() == 0) {
            return null;
        }
        return mData.get(position % mData.size());
    }

    @SuppressLint("CheckResult")
    private void loadCorpImageWithNineBg(final ImageView imageView, final String url, final int placeholderNinePngId) {
        if (imageView == null) {
            return;
        }
        Glide.with(imageView).load(url).apply(RequestOptions.placeholderOf(R.drawable.hp_living_default_bg)).into(imageView);
    }

    class ViewHolder {
        ImageView imageview;
    }
}
