package com.yy.mobile.ui.widget.banner;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Gallery;

import com.yy.mobile.logs.MLog;
import com.yy.mobile.utils.DispatchHandler;

import java.lang.ref.WeakReference;

/**
 * Created by xujiexing on 14-4-25.
 * @author edit by zhongyongsheng
 */
public class AdGallery extends Gallery implements View.OnTouchListener {

    private static final String TAG = "AdGallery";
    private static final int DEFAULT_INTERVAL = 10000;
    private static final int FLIP_MSG = 1;
    private final Handler mHandler = new GalleryHandler(this);
    private int mFlipInterval = DEFAULT_INTERVAL;
    private boolean mAutoStart = false;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mVisible = false;
    private boolean mUserPresent = true;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            final String action = intent.getAction();
            if (Intent.ACTION_SCREEN_OFF.equals(action)) {
                mUserPresent = false;
                updateRunning();
            } else if (Intent.ACTION_USER_PRESENT.equals(action)) {
                mUserPresent = true;
                updateRunning(false);
            }
        }
    };
    private boolean mHasRegisterReceiver = false;

    public AdGallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    public AdGallery(Context context) {
        super(context);
        init();
    }

    public AdGallery(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public void init() {

        this.setOnTouchListener(this);
        this.setSoundEffectsEnabled(false);

        setFocusableInTouchMode(true);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
                           float velocityY) {
        int kEvent;
        if (isScrollingLeft(e1, e2)) {
            kEvent = KeyEvent.KEYCODE_DPAD_LEFT;
        } else {
            kEvent = KeyEvent.KEYCODE_DPAD_RIGHT;
        }

        onKeyDown(kEvent, null);
        return true;

    }

    private boolean isScrollingLeft(MotionEvent e1, MotionEvent e2) {
        return e2.getX() > (e1.getX() + 50);
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
                            float distanceY) {
        return super.onScroll(e1, e2, distanceX, distanceY);
    }

    public void startAutoScroll() {
        startFlipping();
    }

    public void endAutoScroll() {
        stopFlipping();
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        if (MotionEvent.ACTION_UP == event.getAction()
                || MotionEvent.ACTION_CANCEL == event.getAction()) {
            startFlipping();
        } else {
            stopFlipping();
        }
        return false;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();

        registerReceiver();

        if (mAutoStart) {
            // Automatically start when requested
            startFlipping();
        }
    }

    private void registerReceiver() {
        // Listen for broadcasts related to user-presence
        final IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_SCREEN_OFF);
        filter.addAction(Intent.ACTION_USER_PRESENT);
        getContext().registerReceiver(mReceiver, filter, null, mHandler);
        mHasRegisterReceiver = true;
        MLog.INSTANCE.info(TAG, "[onAttachedToWindow] mHasRegisterReceiver = " + mHasRegisterReceiver);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        mVisible = false;
        unregisterReceiver();

        updateRunning();
    }

    private void unregisterReceiver() {
        MLog.INSTANCE.info(TAG, "[onAttachedToWindow] mHasRegisterReceiver = " + mHasRegisterReceiver);
        if (mHasRegisterReceiver) {
            MLog.INSTANCE.info(TAG, "[onAttachedToWindow] unregisterReceiver");
            try {
                getContext().unregisterReceiver(mReceiver);
            } catch (Exception e) {
                MLog.INSTANCE.error(TAG, "unregisterReceiver exception ", e);
            }
            mHasRegisterReceiver = false;
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        mVisible = visibility == VISIBLE;
        updateRunning(false);
    }

    public void startFlipping() {
        mStarted = true;
        updateRunning();
    }

    public void stopFlipping() {
        mStarted = false;
        updateRunning();
    }

    private void updateRunning() {
        updateRunning(true);
    }

    private void updateRunning(boolean flipNow) {
        boolean running = mVisible && mStarted && mUserPresent;
        if (running != mRunning) {
            if (running) {
                setSelection(getSelectedItemPosition(), flipNow);
                Message msg = mHandler.obtainMessage(FLIP_MSG);
                mHandler.sendMessageDelayed(msg, mFlipInterval);
            } else {
                mHandler.removeMessages(FLIP_MSG);
            }
            mRunning = running;
        }
        MLog.INSTANCE.debug(TAG, "updateRunning() mVisible=" + mVisible + ", mStarted=" + mStarted
                + ", mUserPresent=" + mUserPresent + ", mRunning=" + mRunning);
    }


        public boolean isFlipping() {
        return mStarted;
    }

    public boolean isAutoStart() {
        return mAutoStart;
    }

    public void setAutoStart(boolean autoStart) {
        mAutoStart = autoStart;
    }

    public void setFlipInterval(int flipInterval) {
        mFlipInterval = flipInterval;
    }

    private static class GalleryHandler extends DispatchHandler {
        WeakReference<AdGallery> mGallery;
        GalleryHandler(AdGallery gallery) {
            mGallery = new WeakReference<>(gallery);
        }

        @Override
        public void handleMessage(Message msg) {
            AdGallery gallery = mGallery.get();
            if (gallery == null) {
                return;
            }
            if (msg.what == FLIP_MSG) {
                if (gallery.mRunning) {
                    //MLog.debug(TAG, "Move to=" + getSelectedItemPosition());
                    if (gallery.getSelectedItemPosition() >= (gallery.getCount() - 1)) {
                        gallery.setSelection(0, true);
                        gallery.onKeyDown(KeyEvent.KEYCODE_DPAD_LEFT, null);
                    } else {
                        gallery.onKeyDown(KeyEvent.KEYCODE_DPAD_RIGHT, null);
                    }
                    msg = obtainMessage(FLIP_MSG);
                    sendMessageDelayed(msg, gallery.mFlipInterval);
                }
            }
        }
    }
}
