package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;

/**
 * Class Name: RippleView
 * Description: 设置背景颜色波纹效果展示的View
 * Author: 郑永欣
 * Date: 2017/10/19
 * Modified History: 修改记录，格式(Name)  (Version)  (Date) (Reason & Contents)
 */

public class RippleView extends RelativeLayout {

    private static final String TAG = "RippleView";
    int mWidth;
    int mHeight;
    double mRadiusMax;
    float mRadius = 0;
    Paint mPaint;

    int left;
    int right;
    int top;
    int bottom;

    int cx;
    int cy;

    int mBackgoundColor = 0x00ffffff;

    public RippleView(Context context) {
        super(context);
        init(context, null);
    }

    public RippleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public RippleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        setWillNotDraw(false);

        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RippleView);
        mBackgoundColor = ta.getColor(R.styleable.RippleView_rvBackgroundColor, mBackgoundColor);
        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setColor(mBackgoundColor);
        mPaint.setStyle(Paint.Style.FILL);
        mRadius = 0;
        ta.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        mWidth = getMeasuredWidth();
        mHeight = getMeasuredHeight();
        mRadiusMax = Math.sqrt((Math.pow(mWidth / 2, 2) + Math.pow(mHeight / 2, 2)));
        MLog.INSTANCE.debug(TAG, "[onMeasure] mWidth = " + mWidth + ", mHeight = " + mHeight + ", mRadiusMax = " + mRadiusMax);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        left = l;
        right = r;
        top = t;
        bottom = b;
        cx = (l + r) / 2;
        cy = (t + b) / 2;
    }


    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(cx, cy, mRadius, mPaint);
        if (mRadius < mRadiusMax) {
            mRadius += 30;
            postInvalidateDelayed(15);
        } else {
            mRadius = 0;
        }
        MLog.INSTANCE.debug(TAG, "[onDraw] cx = " + cx + ", cy = " + cy + ", mRadius = " + mRadius + ", mPaint +" + mPaint);
    }
}
