package com.yy.mobile.ui.widget

import android.app.DialogFragment
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.Window
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.request.RequestOptions
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.meipai.MPRecommendDialogData
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.utils.DensityUtil
import com.yy.mobile.utils.ScreenUtil
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import kotlinx.android.synthetic.main.hp_dialog_recommend_author.view.*
import java.util.concurrent.TimeUnit

/**
 * 推荐主播弹窗
 *
 * Created by liyang
 * on 2019/8/12
 */
class RecommendAuthorDialog : DialogFragment() {

    companion object {
        const val TAG = "RecommendAuthorDialog"
    }

    private var rootView: View? = null
    private var disposable: Disposable? = null
    private var dialogData: MPRecommendDialogData? = null

    override fun onCreateView(inflater: LayoutInflater?, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        dialog.window?.requestFeature(Window.FEATURE_NO_TITLE)
        rootView = inflater?.inflate(R.layout.hp_dialog_recommend_author, container, false)
        dialogData?.let { setDialogData(it) }
        return rootView
    }

    override fun onStart() {
        super.onStart()
        dialog.apply {
            setCancelable(false)
            setCanceledOnTouchOutside(false)
        }
        dialog.window?.apply {
            setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
            setLayout(
                (ScreenUtil.getScreenWidth(dialog.context) * 0.75).toInt(),
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
        }
    }

    fun setDialogData(dialogData: MPRecommendDialogData) {
        this.dialogData = dialogData
        rootView?.apply {
            val liveInfo = dialogData.getRandomLive()

            // 关闭按钮
            iv_close.setOnClickListener { dialog.dismiss() }
            // 推荐标题
            tv_recommend_title.text = dialogData.title
            // 直播封面
            iv_author_cover.apply {
                Glide.with(this)
                    .load(liveInfo.coverPic)
                    .apply(RequestOptions()
                        .placeholder(ColorDrawable(Color.parseColor("#d7d7d7")))
                        .centerCrop()
                    )
                    .apply(RequestOptions().transforms(CenterCrop(), RoundedCorners(DensityUtil.dp2px(8F))))
                    .into(this)
                setOnClickListener {
                    dismiss()
                    disposable?.dispose()
                    // TODO 跳转直播间
                }
            }
            // 直播标签
            tv_live_tag.apply {
                if (liveInfo.tagStyle == 0 || liveInfo.tag.isEmpty()) {
                    visibility = View.GONE
                } else {
                    text = liveInfo.tag
                    visibility = View.VISIBLE
                }
            }
            // 直播标题
            tv_live_title.text = liveInfo.desc
            // 在线人数
            tv_online_number.text = LivingCoreConstant.formatCountNoUnit(liveInfo.users)
            // 在线人数单位
            tv_unit_wan.visibility = if (liveInfo.users >= 10000) View.VISIBLE else View.GONE
            // 去围观按钮
            tv_go_watching.apply {
                text = String.format(getString(R.string.hp_go_watching_format), dialogData.countdown)
                disposable = Observable.interval(1, TimeUnit.SECONDS, AndroidSchedulers.mainThread())
                    .take(dialogData.countdown.toLong() + 1)
                    .subscribe({
                        text = String.format("去围观 %ds", dialogData.countdown.toLong() - it - 1)
                    }, {
                        dismiss()
                        MLog.error(TAG, it)
                    }, {
                        dismiss()
                        // TODO 跳转直播间
                    })
                setOnClickListener {
                    dismiss()
                    disposable?.dispose()
                    // TODO 跳转直播间
                }
            }
        }
    }

    override fun onDestroy() {
        disposable?.dispose()
        super.onDestroy()
    }
}