/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yy.mobile.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;

/**
 * Created by xianjiachao on 2015/3/18.
 */
public class PressedImageView extends ImageView {
    private static final String TAG = "PressedRecycleImageView";

    public Drawable mPressed;

    public PressedImageView(Context context) {
        super(context);
        init();
    }

    public PressedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public PressedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    private void init() {
        mPressed = getContext().getResources().getDrawable(R.drawable.hp_pressedpecycle_pressed_selector);
        mPressed.setCallback(this);

        if (mPressed.isStateful()) {
            mPressed.setState(getDrawableState());
        }
    }

    public void setPressRound() {
        mPressed = getContext().getResources().getDrawable(R.drawable.hp_pressed_recycle_round_corner_pressed_selector);
        mPressed.setCallback(this);

        if (mPressed.isStateful()) {
            mPressed.setState(getDrawableState());
        }
    }


    @Override
    public void draw(Canvas canvas) {
        try {
        super.draw(canvas);
        mPressed.draw(canvas);
        }catch (Throwable throwable){
            MLog.INSTANCE.error(TAG,throwable.getLocalizedMessage());
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        mPressed.setBounds(0, 0, w, h);
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (mPressed != null && mPressed.isStateful()) {
            mPressed.setState(getDrawableState());
        }
        invalidate();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (mPressed != null) {
            mPressed.setVisible(visibility == VISIBLE, false);
        }
    }
}
