package com.yy.mobile.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.yy.mobile.plugin.pluginunionhomepage.R;


@SuppressLint("AppCompatCustomView")
public class PointImageView extends ImageView {
    private boolean showPoint = false;

    private Paint mPaint;
    private int radius = 0;

    private int pointCenterX;
    private int pointCenterY;


    public PointImageView(Context context) {
        this(context, null);
        init(context);
    }

    public PointImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        pointCenterX = getMeasuredWidth() - radius - getPaddingRight();
        pointCenterY = radius + getPaddingTop();

    }

    private void init(Context context){
        radius = context.getResources().getDimensionPixelSize(R.dimen.hp_common_point_radius);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (showPoint) {
            if(null == mPaint){
                mPaint = new Paint();
                mPaint.setColor(0xffFA2640);
                mPaint.setAntiAlias(true);
//                mPaint.setStrokeWidth((float) 5.0);
            }
            canvas.drawCircle(pointCenterX, pointCenterY , radius, mPaint);
        }
    }

    public void showPoint(boolean showPoint){
        this.showPoint = showPoint;
        invalidate();
    }

    public void setRadius(int radius){
        this.radius = radius;
        invalidate();
    }
}
