package com.yy.mobile.ui.widget

import android.content.Context
import android.support.constraint.ConstraintLayout
import android.support.v4.view.NestedScrollingParent2
import android.support.v4.view.NestedScrollingParentHelper
import android.support.v4.view.ViewCompat
import android.util.AttributeSet
import android.view.View
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.pluginunionhomepage.R

/**
 * @author zhengyongxin
 * @date 创建时间: 2018/6/19
 * @Description 描述
 */
class HomeNestedViewLayout @JvmOverloads constructor(
    val mContext: Context,
    val attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(
    mContext,
    attrs,
    defStyleAttr),
    NestedScrollingParent2 {

    private var firstFinishInflate = true
    private val maxScroll = mContext.resources.getDimension(R.dimen.hp_home_fragment_title_high)
        .toInt()
    private val parentHelper = NestedScrollingParentHelper(this)
    var isEnableHideTop = false
    var isHiddenTop = false

    override fun onFinishInflate() {
        super.onFinishInflate()
        MLog.info(TAG, "onFinishInflate")
    }

    private var scrollDy: Int = 0

    override fun onNestedPreScroll(target: View, dx: Int, dy: Int, consumed: IntArray, type: Int) {
        MLog.debug(TAG, "[onNestedPreScroll], dy=$dy")
        val hiddenTop = (dy > 0) && (scrollDy < maxScroll)
        val showTop = (dy < 0) && scrollDy > 0
        if (hiddenTop || showTop) {
            countScroll(dy)
        }
    }

    /**
     * 移动View的实际位置
     */
    private fun setMarginTop(dy: Int) {
        MLog.debug(TAG, "[setMarginTop] dy=$dy")
        val params = layoutParams as android.support.constraint.ConstraintLayout.LayoutParams
        params.setMargins(0, -dy, 0, 0)
        layoutParams = params
    }

    private fun countScroll(dy: Int) {
        scrollDy += dy
        when (scrollDy) {
            in 0..maxScroll -> {
                scrollToWithDy(scrollDy)
            }
            in maxScroll..Int.MAX_VALUE -> {
                scrollDy = maxScroll
                scrollToWithDy(maxScroll)
            }
            in Int.MIN_VALUE..0 -> {
                scrollDy = 0
                scrollToWithDy(0)
            }
        }
    }

    override fun onStopNestedScroll(target: View, type: Int) {
        MLog.info(TAG, "onStopNestedScroll")
        when (scrollDy) {
            in 0..maxScroll / 2 -> scrollToWithDy(0)
            in Int.MIN_VALUE..0 -> scrollToWithDy(0)
            in maxScroll / 2..Int.MAX_VALUE -> scrollToWithDy(maxScroll)
        }
    }

    private fun scrollToWithDy(y: Int) {
        when (y) {
            in 0..maxScroll / 2 -> {
                isHiddenTop = false
            }
            in maxScroll / 2..maxScroll -> {
                isHiddenTop = true
            }
        }
        scrollTo(0, y - maxScroll)
    }

    override fun onStartNestedScroll(child: View, target: View, axes: Int, type: Int): Boolean {
        MLog.info(TAG, "[onStartNestedScroll]")
        if (firstFinishInflate && isEnableHideTop) {
            setMarginTop(maxScroll)
            scrollToWithDy(0)
            firstFinishInflate = false
        }
        if (!isEnableHideTop) {
            return false
        }
        return axes == ViewCompat.SCROLL_AXIS_VERTICAL
    }

    override fun onNestedScroll(
        target: View,
        dxConsumed: Int,
        dyConsumed: Int,
        dxUnconsumed: Int,
        dyUnconsumed: Int,
        type: Int
    ) {
        MLog.info(TAG, "[onNestedScroll]")
    }

    override fun onNestedScrollAccepted(child: View, target: View, axes: Int) {
        MLog.info(TAG, "[onNestedScrollAccepted]")
        parentHelper.onNestedScrollAccepted(child, target, axes)
    }

    override fun onNestedScrollAccepted(child: View, target: View, axes: Int, type: Int) {
        MLog.info(TAG, "[onNestedScrollAccepted]")
        parentHelper.onNestedScrollAccepted(child, target, axes, type)
    }

    override fun getNestedScrollAxes(): Int {
        MLog.info(TAG, "[getNestedScrollAxes]")
        return parentHelper.nestedScrollAxes
    }

    override fun onStopNestedScroll(child: View) {
        MLog.info(TAG, "[onStopNestedScroll]")
        parentHelper.onStopNestedScroll(child)
    }

    override fun onNestedPreFling(target: View, velocityX: Float, velocityY: Float): Boolean {
        MLog.info(TAG, "onNestedPreFling")
        return false
    }

    override fun onNestedFling(
        target: View,
        velocityX: Float,
        velocityY: Float,
        consumed: Boolean
    ): Boolean {
        MLog.info(TAG, "onNestedPreFling")
        return false
    }

    companion object {
        const val TAG = "HomeNestedViewLayout"
    }
}