package com.yy.mobile.ui.viewholder

import android.graphics.Color
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.api.HPBasicActionHandler
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.follow.FollowTitle
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.plugin.pluginunionhomepage.Rs

/**
 * Created by PYF on 2019/3/5
 */

@MultiLineType(type = [(LivingCoreConstant.Live_MODULE_COMMON_TITLE_CODE)],
        xml = Rs.layout.hp_item_living_module_title, contentClass = LineDataMultiType::class)
class TitleViewHolder(val view: View, callback: IMultiLinePresenter)
    : BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    private var decoration: ImageView = view.findViewById(R.id.live_title_decoration)
    private var title: TextView = view.findViewById(R.id.txt_living_title)
    private var more: ImageView = view.findViewById(R.id.img_living_more)
    private var line: View = view.findViewById(R.id.living_module_seperator)
    private var container: View = view.findViewById(R.id.rl_living_title_container)
    private var managerFollow: TextView = itemView.findViewById(R.id.txt_manager_follow)

    override fun onBindViewHolder(data: LineDataMultiType) {
        val actualData = data.data as FollowTitle

        title.text = "正在直播(${actualData.liveCount})"
        title.setTextColor(Color.parseColor("#000000"))
        container.isEnabled = false
        container.setBackgroundResource(R.color.hp_color_white)
        more.visibility = View.GONE

        if (actualData.liveCount > 0) {
            managerFollow.visibility = View.VISIBLE
        } else {
            managerFollow.visibility = View.GONE
        }

        managerFollow.setOnClickListener {
            //这里面需要拉插件
            HPBasicActionHandler.handleEnterFollow()
        }
    }
}