package com.yy.mobile.ui.viewholder;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.yy.mobile.data.main.SubNavInfoData;
import com.yy.mobile.data.nav.LiveNavInfo;
import com.yy.mobile.data.nav.SubLiveNavItem;
import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.statistic.HiidoReportHelper;
import com.yy.mobile.ui.subnav.SubNavActivity;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by shobal on 16/11/23.
 */

public class TagRecyclerViewAdapter extends RecyclerView.Adapter<TagRecyclerViewAdapter.ViewHolder> {
    private static final String TAG = "TagRecyclerViewAdapter";
    private List<SubNavInfoData> mData = new ArrayList<>();
    private LiveNavInfo mNavInfo;
    private Context mContext;
    private String from;

    public TagRecyclerViewAdapter(Context mContext) {
        this.mContext = mContext;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.hp_item_living_tag, null);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull final ViewHolder holder, final int position) {
        if (position >= mData.size()) {
            return;
        }
        final SubNavInfoData item = mData.get(position);
        try {
            holder.mTitle.setTextColor(Color.parseColor(item.getColor()));
        } catch (Exception e) {
            MLog.INSTANCE.info(TAG, "onBindViewHolder ", e);
            holder.mTitle.setTextColor(Color.parseColor("#333333"));
        }
        //本地flag小于服务器flag则显示redhot,点击时记录服务器flag
        holder.mHotmageView.setVisibility(View.GONE);
//        final String key = "hotspot_" + mNavInfo.biz + "_" + item.getId();
        final String key = "hotspot_" + "pyf" + "_" + item.getId();
        holder.mWrapLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                notifyItemChanged(position);
                toLivingMorePageFrom(holder.mHotmageView.getContext(), item.getTitle(), mNavInfo, item);

                //数据上报
                HiidoReportHelper.INSTANCE.sendSubItemClick(HiidoReportHelper.INSTANCE.getPageId(mNavInfo.biz, item.getAction()));
            }
        });
        holder.mTitle.setText(item.getTitle());
    }


    public static void toLivingMorePageFrom(Context context, String name, LiveNavInfo info, SubNavInfoData subNavInfo) {
        Intent intent = new Intent(context, SubNavActivity.class);
        intent.putExtra(SubNavActivity.LIVE_TAB_NAME, name);
        intent.putExtra(SubNavActivity.LIVE_NAV_INFO, info);
        //原始数据类和 面向使用的数据类的一个巨大区别，没有实现Parcelable
        SubLiveNavItem navItem = new SubLiveNavItem(info.serv, subNavInfo.getAction());
        intent.putExtra(SubNavActivity.LIVE_SUB_NAV_INFO, navItem);
        intent.putExtra(SubNavActivity.FRAGMENT_TYPE, SubNavActivity.FRAGMENT_SUB_PAGE);
        context.startActivity(intent);
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    public void setData(List<SubNavInfoData> datas) {
        mData.clear();
        mData.addAll(datas);
        notifyDataSetChanged();
    }

    public void setNavInfo(LiveNavInfo info, String from) {
        this.mNavInfo = info;
        this.from = from;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        public ImageView mHotmageView;
        public TextView mTitle;
        public View mWrapLayout;

        public ViewHolder(View v) {
            super(v);
            mTitle = v.findViewById(R.id.txt_title);
            mHotmageView = v.findViewById(R.id.img_tips);
            mWrapLayout = v.findViewById(R.id.tag_Wrap_layout);
        }
    }
}
