package com.yy.mobile.ui.viewholder

import android.graphics.Color
import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.View
import android.widget.AbsListView
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.main.SubNavInfoData
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.plugin.pluginunionhomepage.Rs
import com.yy.mobile.presenter.MultiLinePresenter
import com.yy.mobile.utils.DensityUtil
import com.yy.mobile.utils.FP

/**
 * Created by PYF on 2019/3/2
 * 二级标签的viewholder
 */

@MultiLineType(type = [(LivingCoreConstant.Live_MODULE_TAG_CODE)],
        xml = Rs.layout.hp_item_living_horizontal_recyclerview, contentClass = LineDataMultiType::class)
class SubNavViewHolder(view: View, callback: IMultiLinePresenter)
    : BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    private var tagView: RecyclerView? = null
    private var tagAdapter: TagRecyclerViewAdapter? = null

    init {
        tagView = view as RecyclerView
        val layoutParams = AbsListView.LayoutParams(AbsListView.LayoutParams.MATCH_PARENT, AbsListView.LayoutParams.WRAP_CONTENT)
        tagView?.layoutParams = layoutParams
        tagView?.setBackgroundColor(Color.WHITE)
        tagView?.setHasFixedSize(true)
        tagView?.layoutManager = GridLayoutManager(tagView?.context, 4)
        tagView?.setPadding(0, DensityUtil.dp2px(10f), 0, DensityUtil.dp2px(10f))
        tagAdapter = TagRecyclerViewAdapter(tagView?.context)
        tagAdapter?.setNavInfo((multiLinePresenter as MultiLinePresenter).navInfo, "")
    }

    override fun onBindViewHolder(lineData: LineDataMultiType) {
        MLog.info("SubNavViewHolder", "onBindViewHolder: data = $lineData")
        val tagInfoList = lineData.data as? List<SubNavInfoData>
        //
//        tagAdapter?.setNavInfo(getNavInfo(), getSubNavInfo(), lineData.id, getFrom())
        tagAdapter?.setData(tagInfoList)
        tagView?.adapter = tagAdapter
//        initLoadStatic(tagInfoList)
        if (!FP.empty(tagInfoList)) {
            tagView?.visibility = View.VISIBLE
            val left = DensityUtil.dp2px(4f)
            val top = DensityUtil.dp2px(7f)
            tagView?.setPadding(left, top, left, top)
        } else {
            tagView?.visibility = View.GONE
        }
    }
}