package com.yy.mobile.ui.viewholder;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

/**
 * Created by azipage on 2018/1/22.
 */

public class SpaceItemDecoration extends RecyclerView.ItemDecoration {
    private int mTop;
    private int mLeft;
    private int mRight;
    private int mBottom;
    private int color = Color.WHITE;

    public SpaceItemDecoration(int mTop, int mLeft, int mRight, int mBottom) {
        this.mTop = mTop;
        this.mLeft = mLeft;
        this.mRight = mRight;
        this.mBottom = mBottom;
    }

    public SpaceItemDecoration(int right, int bottom) {
        this.mRight = right;
        this.mBottom = bottom;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        //这个space 要修改下
        GridLayoutManager layoutManager = (GridLayoutManager) parent.getLayoutManager();
        int childPosition = parent.getChildAdapterPosition(view);
        if ((childPosition + 1) % layoutManager.getSpanCount() != 0) {
            outRect.right = mRight;
            outRect.bottom = mBottom;
        }
    }


    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        c.drawColor(color);
    }
}
