package com.yy.mobile.ui.viewholder

import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.View
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.data.meipai.MPNavigationData
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.pluginunionhomepage.Rs
import com.yy.mobile.statistic.HiidoReportHelper

/**
 * Created BY PYF 2019/6/5
 * email: pengyangfan@yy.com
 */

@MultiLineType(type = [(LivingCoreConstant.MP_LIVE_MODULE_NAVIGATION_CODE)],
    xml = Rs.layout.hp_item_navigation_recyclerview,
    contentClass = LineDataMultiType::class)
class NavigationViewHolder(val view: View, callback: IMultiLinePresenter) :
    BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    override fun onBindViewHolder(data: LineDataMultiType) {
        view as RecyclerView
        view.layoutManager = LinearLayoutManager(view.context, LinearLayoutManager.HORIZONTAL, false)
        view.adapter = NavigationViewAdapter(view.context, (data.data as MutableList<MPNavigationData>))
        view.adapter.notifyDataSetChanged()
    }

    private var first = -1
    private var end = -1

    override fun onViewDetachedFromWindow() {
        super.onViewDetachedFromWindow()
        MLog.info("exposure", "Navigation onViewDetachedFromWindow")
        view as RecyclerView
        first = (view.layoutManager as LinearLayoutManager).findFirstVisibleItemPosition()
        end = (view.layoutManager as LinearLayoutManager).findLastVisibleItemPosition()
    }

    override fun onViewAttachedToWindow() {
        super.onViewAttachedToWindow()
        MLog.info("exposure", "Navigation onViewAttachedToWindow")
        //传入first 和 end
        HiidoReportHelper.exposure()
    }
}