package com.yy.mobile.ui.viewholder

import android.content.Context
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.yy.mobile.data.meipai.MPNavigationData
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.ui.widget.RecommendAuthorDialog
import com.yy.mobile.utils.ScreenUtil
import tv.athena.util.toast.ToastUtil

/**
 * Created BY PYF 2019/6/5
 * email: pengyangfan@yy.com
 */
class NavigationViewAdapter(val context: Context, val data: MutableList<MPNavigationData>) :
    RecyclerView.Adapter<NavigationViewAdapter.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) =
        ViewHolder(LayoutInflater.from(context).inflate(R.layout.hp_item_navigation, parent, false))

    override fun getItemCount() = data.size

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.rootView.apply {
            layoutParams = layoutParams.apply {
                // 最多显示五个，多的滑动可查看
                width = ScreenUtil.getScreenWidth(holder.rootView.context) / 5
            }
            setOnClickListener {
                ToastUtil.showToast("navigation clicked")
            }
        }
        holder.ivNavTitle.text = data[position].title
        Glide.with(holder.ivNavImage)
            .load(data[position].image)
            .apply(RequestOptions.placeholderOf(R.drawable.hp_living_default_bg))
            .into(holder.ivNavImage)
    }

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val rootView = view
        val ivNavImage: ImageView = view.findViewById(R.id.iv_nav_image)
        val ivNavTitle: TextView = view.findViewById(R.id.tv_nav_title)
    }
}