package com.yy.mobile.ui.viewholder

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.support.constraint.ConstraintLayout
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import android.widget.Toast
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.api.HPBasicActionHandler
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.data.meipai.MPLiveInfoData
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.plugin.pluginunionhomepage.Rs
import com.yy.mobile.presenter.MultiLinePresenter
import com.yy.mobile.statistic.HiidoReportHelper
import com.yy.mobile.statistic.VHolderHiidoInfo
import com.yy.mobile.ui.homepage.HomeContentFragment
import com.yy.mobile.ui.subnav.SubNavContentFragment
import com.yy.mobile.utils.DensityUtil
import com.yy.mobile.utils.ScreenUtil

/**
 * Created by PYF on 2019/3/3
 * 重头戏，豆腐块ViewHolder
 */
@MultiLineType(type = [
    (LivingCoreConstant.LIVING_TYPE_MOBILE_LIVE),
    (LivingCoreConstant.LIVING_TYPE_MOBILE_REPLAY),
    (LivingCoreConstant.LIVING_TYPE_SHOW_LIVE),
    (LivingCoreConstant.LIVING_TYPE_GAME_LIVE),
    (LivingCoreConstant.MP_LIVE_MODULE_CODE)],
    xml = Rs.layout.hp_item_living_live_common_module,
    contentClass = LineDataMultiType::class
)
class LiveModuleViewHolder(val view: View, val callback: IMultiLinePresenter) :
    BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    private val clContainer: View = view.findViewById(R.id.cl_live_container)// 根布局
    private val piLiveThumb: ImageView = view.findViewById(R.id.pi_live_thumb)// 直播封面
    private val tvLiveStatus: TextView = view.findViewById(R.id.tv_live_status)// 直播状态
    private val tvLiveTitle: TextView = view.findViewById(R.id.tv_live_title)// 直播标题
    private val tvLiveTag: TextView = view.findViewById(R.id.tv_live_tag)// 直播标签
    private val tvOnlineNumber: TextView = view.findViewById(R.id.tv_online_number)// 在线人数
    private val tvUnitWan: TextView = view.findViewById(R.id.tv_unit_wan)// 在线人数单位(万)

    override fun onBindViewHolder(lineDataMultiType: LineDataMultiType) {
        MLog.info("LiveModuleViewHolder", "onBindViewHolder: lineDataMultiType = $lineDataMultiType")

        // 目前只有一种首页类型，直接就默认一种
        val liveInfoData = lineDataMultiType.data as MPLiveInfoData
        val height = (ScreenUtil.getScreenWidth(view.context) - DensityUtil.dp2px(2f)) * 2 / 3
        piLiveThumb.layoutParams = ConstraintLayout.LayoutParams(ConstraintLayout.LayoutParams.MATCH_PARENT, height)
        tvLiveTitle.text = liveInfoData.desc
        tvOnlineNumber.text = LivingCoreConstant.formatCountNoUnit(liveInfoData.users)
        tvUnitWan.visibility = if (liveInfoData.users >= 10000) View.VISIBLE else View.GONE
        tvLiveTag.run {
            if (liveInfoData.tagStyle == 0 || liveInfoData.tag.isEmpty()) {
                visibility = View.GONE
            } else {
                text = liveInfoData.tag
                visibility = View.VISIBLE
            }
        }
        Glide.with(piLiveThumb)
            .load(liveInfoData.coverPic)
            .apply(RequestOptions().placeholder(ColorDrawable(Color.parseColor("#d7d7d7"))))
            .into(piLiveThumb)
        tvLiveStatus.run {
            when (liveInfoData.liveType) {
                1 -> {// 直播中
                    text = context.getText(R.string.hp_living)
                    background = null
                }
                2 -> {// 连麦中
                    text = context.getText(R.string.hp_call)
                    background = null
                }
                3 -> {// 正在PK
                    text = context.getText(R.string.hp_in_pk)
                    background = context.resources.getDrawable(R.drawable.hp_shape_in_pk)
                }
            }
        }

        setContainerOnclick(liveInfoData)
    }

    override fun onViewAttachedToWindow() {
        super.onViewAttachedToWindow()
        MLog.info("exposure", "LiveModule onViewAttachedToWindow pyf: text = " +
            "${tvLiveTitle.text}, number = ${tvOnlineNumber.text}")
    }

    override fun onViewDetachedFromWindow() {
        super.onViewDetachedFromWindow()
        MLog.info("exposure", "LiveModule onViewDetachedFromWindow pyf: text = " +
            "${tvLiveTitle.text}, number = ${tvOnlineNumber.text}")
        //曝光走detached  还挺准的
        HiidoReportHelper.exposure()
    }

    private fun setContainerOnclick(data: MPLiveInfoData) {
        clContainer.setOnClickListener {
            Toast.makeText(view.context, "豆腐块被点击了", Toast.LENGTH_SHORT).show()
            HPBasicActionHandler.handleEnterLiveRoom(data.sid, data.ssid)
            //数据上报
            val presenter = (multiLinePresenter as MultiLinePresenter)
            //如果是来自首页则上报
//            HiidoReportHelper.sendHPVHolderClick()
            //二级tab的点击
            when (presenter.fromType) {
                HomeContentFragment.TAG -> {
                    //moduleId = linedata里的id
                    HiidoReportHelper.sendHPVHolderClick(VHolderHiidoInfo
                        .Builder(presenter.navInfo, presenter.subNavBiz, presenter.fromType, 103093)
                        .sid(data.sid)
                        .ssid(data.ssid)
                        .uid(data.uid)
//                        .token(data.token)
                        .create()
                    )
                }
                SubNavContentFragment.TAG -> {
                    HiidoReportHelper.sendMoreVHolderClick(
                        HiidoReportHelper.getPageId(presenter.navInfo?.biz, presenter.subNavBiz),
                        data.sid, data.uid)
                }
            }
        }
    }
}