package com.yy.mobile.ui.viewholder

import android.graphics.Rect
import android.support.v7.widget.RecyclerView
import android.view.View
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.mainbean.LineDataMultiType

/**
 * Created BY PYF 2019/6/5
 * email: pengyangfan@yy.com
 * 直播块的间距
 */

class LiveModuleItemDecoration(private val space: Int) : RecyclerView.ItemDecoration() {

    var lastIndex = -1 //记录最后一个出现的非直播豆腐块模块的下标

    override fun getItemOffsets(outRect: Rect?, view: View?, parent: RecyclerView?, state: RecyclerView.State?) {
        super.getItemOffsets(outRect, view, parent, state)
        val holder = parent?.getChildViewHolder(view) ?: return
        val position = parent.getChildLayoutPosition(view)
        val firstLivePosition = (parent.adapter as HomeContentAdapter).items.indexOfFirst {
            it is LineDataMultiType && it.type == LivingCoreConstant.MP_LIVE_MODULE_CODE
        }
        //怎么判断比较好判断呢
        if (holder is LiveModuleViewHolder) {
            if ((position - firstLivePosition) % 2 > 0) {
                //右
                outRect?.left = space / 2
                outRect?.right = space
                outRect?.bottom = space
            } else {
                //左
                outRect?.left = space
                outRect?.right = space / 2
                outRect?.bottom = space
            }
        } else {
            lastIndex = position
        }
    }
}