package com.yy.mobile.ui.viewholder;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;

import com.yy.mobile.data.mainbean.LineDataMultiType;
import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter;
import com.yy.mobile.plugin.homeapi.ui.multiline.MultiLineFactory;
import com.yy.mobile.ui.viewholder.factory.ViewBinderMappingEx;

import java.util.Collections;
import java.util.List;

import me.drakeet.multitype.Linker;
import me.drakeet.multitype.MultiTypeAdapter;
import me.drakeet.multitype.MultiTypePool;
import me.drakeet.multitype.TypePool;

/**
 * Created by azipage on 2018/1/22.
 */

public class HomeContentAdapter extends MultiTypeAdapter {

    private static final String TAG = "HomeContentAdapter";
    private IMultiLinePresenter mPresenter;
    private String mPageId;

    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter, String pageId) {
        this(presenter, pageId, Collections.emptyList());
    }


    /**
     * Constructs a MultiTypeAdapter with a items list.
     *
     * @param items the items list
     */
    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter, String pageId, @NonNull List<?> items) {
        this(presenter, pageId, items, new MultiTypePool());
    }


    /**
     * Constructs a MultiTypeAdapter with a items list and an initial capacity of TypePool.
     *
     * @param items the items list
     * @param initialCapacity the initial capacity of TypePool
     */
    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter, String pageId, @NonNull List<?> items, int initialCapacity) {
        this(presenter, pageId, items, new MultiTypePool(initialCapacity));
    }


    /**
     * Constructs a MultiTypeAdapter with a items list and a TypePool.
     *
     * @param items the items list
     * @param pool the type pool
     */
    public HomeContentAdapter(@NonNull IMultiLinePresenter presenter, String pageId, @NonNull List<?> items, @NonNull TypePool pool) {
        super(items, pool);
        mPresenter = presenter;
        mPageId = pageId;
        registerHolder();
    }

    @Override
    public void setItems(@NonNull List<?> items) {
        super.setItems(items);
        //这个想干嘛，首页做了很多数据保存，这个一时半会还没参透他的意义。
//        IHomePageDartsApi.getCore(IHomepageLiveCore.class).savePageData(mPageId, new ArrayList<>(items));
    }

    @SuppressWarnings("unchecked")
    private void registerHolder() {
        final MultiLineFactory multiLineFactory = MultiLineFactory.getInstance(new ViewBinderMappingEx(mPresenter));
        register(LineDataMultiType.class).to(multiLineFactory.getBinders()).withLinker(new Linker<LineDataMultiType>() {
            @Override
            public int index(int position, @NonNull LineDataMultiType lineData) {
                int pos = multiLineFactory.getPosition(lineData.getType());
                if (pos < 0) {
                    return multiLineFactory.getPosition(-1);
                }
                return pos;
            }
        });
    }

    public void addItems(@NonNull List items) {
        getItems().addAll(items);
//        IHomePageDartsApi.getCore(IHomepageLiveCore.class).savePageData(mPageId, new ArrayList<>(getItems()));
    }
}
