package com.yy.mobile.ui.viewholder

import android.view.View
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.api.HPBasicActionHandler
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.plugin.pluginunionhomepage.Rs
import com.yy.mobile.statistic.HiidoReportHelper
import com.yy.mobile.ui.widget.CircleCompatImageView
import com.yy.mobile.utils.DensityUtil
import com.yy.mobile.utils.ScreenUtil
import com.yy.mobile.utils.TextViewUtil

/**
 * Created by wangrunxiang on 2018/8/11.
 **/
@MultiLineType(type = [LivingCoreConstant.Live_MODULE_FOLLOW_LIVING_TYPE],
    xml = Rs.layout.hp_item_follow_live_living, contentClass = LiveInfoData::class)
class FollowLivingViewHolder(
    val view: View,
    contentInfo: IMultiLinePresenter
) : BaseViewHolder<LiveInfoData, IMultiLinePresenter>(view, contentInfo) {

    private val ivCover: ImageView = view.findViewById(R.id.iv_cover)
    private val ivUserLogo: CircleCompatImageView = view.findViewById(R.id.iv_user_logo)
    private val ivUserName: TextView = view.findViewById(R.id.tv_user_name)
    private val ivVerify: ImageView = view.findViewById(R.id.iv_verify)
    private val tvTag: TextView = view.findViewById(R.id.living_common_tag)
    private val rlRoot: RelativeLayout = view.findViewById(R.id.follow_live_rl_root)
    private val tvAudienceCount: TextView = view.findViewById(R.id.tv_audience_count)

    override fun onBindViewHolder(lineData: LiveInfoData) {
        MLog.info("FollowLivingViewHolder", "onBindViewHolder: data = $lineData")
//        rlRoot.visibility = if (lineData.id == -1) View.GONE else View.VISIBLE
        val height = (ScreenUtil.getScreenWidth(view.context) -
            DensityUtil.dp2px(3f)) / 2 / 16 * 9
        ivCover.layoutParams =
            RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, height)
        Glide.with(ivCover)
            .load(lineData.img)
            .apply(RequestOptions.placeholderOf(R.drawable.hp_default_mob_live_drawable))
            .into(ivCover)
        Glide.with(ivUserLogo)
            .load(lineData.avatar)
            .apply(RequestOptions.placeholderOf(R.drawable.hp_default_portrait))
            .into(ivUserLogo)

        ivUserName.text = lineData.name
        //目测没用直接干掉
//        val verify = 0
//        when (verify) {
//            1 -> {
////                ivVerify.visibility = View.VISIBLE
////                ivVerify.setImageResource(R.drawable.hp_common_portrait_auth_v_1)
////            }
////            2 -> {
////                ivVerify.visibility = View.VISIBLE
////                ivVerify.setImageResource(R.drawable.hp_common_portrait_auth_v_10)
////            }
////            else -> {
////                ivVerify.visibility = View.GONE
////            }
//        }
        TextViewUtil.setLiveTagFromTagStyle(tvTag.context,
            tvTag, lineData.tagStyle, lineData.tag)
        tvAudienceCount.text = LivingCoreConstant.formatCount(lineData.users.toLong())
        rlRoot.setOnClickListener {
            HPBasicActionHandler.handleEnterLiveRoom(lineData.sid, lineData.ssid)

            HiidoReportHelper.sendSubscribeItemClick(lineData.uid, lineData.sid)
        }
    }
}