package com.yy.mobile.ui.viewholder

import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.View
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.DefaultViewHolderMapping
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.plugin.homeapi.ui.multiline.MultiLineFactory
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.plugin.pluginunionhomepage.Rs
import com.yy.mobile.presenter.MultiLinePresenter
import com.yy.mobile.ui.viewholder.factory.ViewBinderMappingEx
import com.yy.mobile.utils.DensityUtil
import me.drakeet.multitype.ItemViewBinder
import me.drakeet.multitype.MultiTypeAdapter

/**
 * Created by PYF on 2019/3/3
 */

@MultiLineType(type = [(LivingCoreConstant.Live_MODULE_CONTENT_CODE),
    (LivingCoreConstant.Live_MODULE_STAR_CONTENT_CODE),
    (LivingCoreConstant.Live_MODULE_BRAND_CONTENT_CODE),
    (LivingCoreConstant.Live_MODULE_FOLLOW_LIVING),
    (LivingCoreConstant.Live_MODULE_TASTE_LIVE)],
    xml = Rs.layout.hp_item_living_horizontal_recyclerview, contentClass = LineDataMultiType::class)
class DoubleLiveViewHolder(val view: View, callback: IMultiLinePresenter) :
    BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    private var recyclerView: RecyclerView = view as RecyclerView

    init {
        recyclerView.layoutManager = GridLayoutManager(view.context, 2)
        val space = DensityUtil.dp2px(10f)
        recyclerView.addItemDecoration(SpaceItemDecoration(space, 0))
        val presenter = MultiLinePresenter()
        val adapter = MultiTypeAdapter()
        val factory = MultiLineFactory.getInstance(DefaultViewHolderMapping(presenter))
        adapter.register(LiveInfoData::class.java).to(*factory.binders as Array<out ItemViewBinder<LiveInfoData, *>>)
            .withLinker { position, data ->
                var pos = factory.getPosition(data.type)
                if (pos < 0) {
                    pos = factory.getPosition(LivingCoreConstant.LIVING_TYPE_MOBILE_LIVE)
                }
                if (data.fromType == LivingCoreConstant.Live_MODULE_FOLLOW_LIVING.toString()) {
                    pos = factory.getPosition(LivingCoreConstant.Live_MODULE_FOLLOW_LIVING_TYPE)
                }
                return@withLinker pos
            }
        recyclerView.adapter = adapter
    }

    override fun onBindViewHolder(data: LineDataMultiType) {
        MLog.info("DoubleLiveViewHolder", "onBindViewHolder: data = $data")
        val adapter = recyclerView.adapter as MultiTypeAdapter
        val dataList = data.data as List<LiveInfoData>
        adapter.items = dataList
        adapter.notifyDataSetChanged()
    }
}