package com.yy.mobile.ui.viewholder

import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.RelativeLayout
import android.widget.Toast
import com.duowan.mobile.plugin.homepage.multiline.MultiLineType
import com.yy.mobile.api.HPBasicActionHandler
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.main.BannerData
import com.yy.mobile.data.meipai.MPBannerData
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.homeapi.ui.multiline.BaseViewHolder
import com.yy.mobile.plugin.homeapi.ui.multiline.IMultiLinePresenter
import com.yy.mobile.ui.widget.banner.HPTopBannerGallery
import com.yy.mobile.ui.widget.banner.TopBanner
import com.yy.mobile.utils.ScreenUtil
import java.util.ArrayList
import kotlin.math.roundToInt

/**
 * Created by PYF on 2019/3/2
 * 搬运ViewHolder系列之Banner
 */

@MultiLineType(type = [
    LivingCoreConstant.Live_MODULE_BANNER_CODE,
    LivingCoreConstant.MP_LIVE_MODULE_BANNER_CODE,
    LivingCoreConstant.MP_LIVE_MODULE_CONTENT_BANNER],
    viewClass = TopBanner::class,
    contentClass = LineDataMultiType::class)
class BannerViewHolder(val view: View, callback: IMultiLinePresenter) :
    BaseViewHolder<LineDataMultiType, IMultiLinePresenter>(view, callback) {

    private var tBanner: TopBanner? = null
    private var bannerId: Int = 0

    init {
        tBanner = view as? TopBanner
        val bannerHeight = (ScreenUtil.getScreenWidth(view.context).toFloat() * (206f / 750f)).roundToInt()
        tBanner?.layoutParams = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, bannerHeight)
    }

    override fun onBindViewHolder(lineData: LineDataMultiType) {
        MLog.info(TAG, "onBindViewHolder: data = $lineData")
        val bannerItemInfos = lineData.data as ArrayList<MPBannerData>
        if (bannerItemInfos.size == 0) {
            MLog.info(TAG, "banner info is null")
            return
        }
        bannerId = lineData.id
        //这些信息待完整之后确认是否需要使用
//        tBanner?.setNav(getNavInfo(), getSubNavInfo(), getFrom())
        tBanner?.setBannerId(bannerId)
        tBanner?.setData(bannerItemInfos, LivingCoreConstant.Live_MODULE_BANNER_CODE)
        tBanner?.setOnItemClickListener(mBanClick)
        tBanner?.startAutoScroll()
    }

    private val mBanClick = AdapterView.OnItemClickListener { parent, view, position, id ->
        val gallery = parent as HPTopBannerGallery
        val mSize = gallery.data.size
        val info = gallery.getItemInfo(position) as? BannerData
        MLog.info(TAG, "mBanClick")
        info?.let {
            when (it.actionType) {
                LivingCoreConstant.BANNER_LIVE_TYPE -> {
                    HPBasicActionHandler.handleEnterLiveRoom(it.sid, it.ssid)
                }
                LivingCoreConstant.BANNER_WEB_TYPE -> {
                    HPBasicActionHandler.handleEnterH5(it.action)
                }
            }
        }
        Toast.makeText(view.context, "Banner Click", Toast.LENGTH_SHORT).show()
    }

    override fun onViewAttachedToWindow() {
        super.onViewAttachedToWindow()
        tBanner?.inWindow = true
        MLog.info("exposure", "BannerViewHolder onViewAttachedToWindow pyf")
    }

    override fun onViewDetachedFromWindow() {
        super.onViewDetachedFromWindow()
        tBanner?.inWindow = false
        MLog.info("exposure", "BannerViewHolder onViewDetachedFromWindow pyf")
    }

    companion object {
        const val TAG = "BannerViewHolder"
    }
}