package com.yy.mobile.ui.subnav

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.view.View
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.ui.homepage.HomeContentFragment
import kotlinx.android.synthetic.main.hp_activity_follow_live.*
import kotlinx.android.synthetic.main.hp_layout_living_other_page.*

/**
 * Created by PYF on 2019/3/2
 */

class SubNavActivity : AppCompatActivity() {

    companion object {
        const val LIVE_TAB_NAME = "live_tab_name"
        const val LIVE_NAV_INFO = "live_nav_info"
        const val LIVE_SUB_NAV_INFO = "live_sub_nav_info"
        const val LIVE_MODULE_ID = "live_module_id"
        const val FRAGMENT_TYPE = "fragment_type"
        const val FRAGMENT_SUB_PAGE = 1 //二级页面
    }

    private lateinit var navInfo: LiveNavInfo
    private lateinit var subLiveNavItem: SubLiveNavItem
    private var title: String = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.hp_layout_living_other_page)
        val intent = intent
        navInfo = intent.extras.get(LIVE_NAV_INFO) as LiveNavInfo
        subLiveNavItem = intent.extras.get(LIVE_SUB_NAV_INFO) as SubLiveNavItem
        title = intent.extras.get(LIVE_TAB_NAME) as String
        supportFragmentManager.beginTransaction()
            .replace(R.id.living_other_page_content,
                SubNavContentFragment.newInstance(navInfo, subLiveNavItem, -1)).commitAllowingStateLoss()
        living_other_page_bar.setLeftBtn(R.drawable.hp_icon_nav_back) { finish() }
        living_other_page_bar.setTitlte(title)
    }
}