package com.yy.mobile.ui.homepage

import android.support.v4.app.Fragment
import android.support.v4.app.FragmentManager
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.ui.widget.pager.PagerSelectedAdapter

/**
 * Created by PYF on 2019/3/4
 */

class HomePagerAdapter(fm: FragmentManager) : PagerSelectedAdapter(fm) {

    var navList: MutableList<LiveNavInfo> = mutableListOf()

    override fun getItem(position: Int): Fragment {
        val navInfo = navList[position]
        val subNavInfo = SubLiveNavItem(navInfo.serv, navInfo.name, LivingCoreConstant.LIVE_URL_FIXED_IDX_STR, 0, 0)
        return HomeContentFragment.newInstance(navInfo, subNavInfo, position)
    }

    override fun getCount(): Int {
        return navList.size
    }

    override fun getPageTitle(position: Int): CharSequence? {
        return navList[position].name
    }

    fun getSelectedPage(): Int {
        navList.forEachIndexed { index, liveNavInfo ->
            if (liveNavInfo.selected == 1) {
                return index
            }
        }
        return 0
    }
}