package com.yy.mobile.ui.homepage

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v4.util.ArraySet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.presenter.homepage.HomeFragmentPresenter
import com.yy.mobile.statistic.HiidoReportHelper
import com.yy.mobile.ui.follow.LiveNoticeTipsLayout
import kotlinx.android.synthetic.main.hp_fragment_home_layout.*

/**
 * Created by PYF on 2019/3/4
 * 终极考验
 */

class HomeFragment : Fragment(), IHomeView {

    private lateinit var rootView: View
    lateinit var presenter: HomeFragmentPresenter

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        rootView = inflater.inflate(R.layout.hp_fragment_home_layout, null)
        presenter = HomeFragmentPresenter(this)
        return rootView
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        assignViews()
    }

    private fun assignViews() {
        presenter.mpRequestNavData()
        presenter.requestSubscribeInfo() //没做重试
    }

    override fun setUserVisibleHint(isVisibleToUser: Boolean) {
        super.setUserVisibleHint(isVisibleToUser)
        HiidoReportHelper.currentFragmentVisible = isVisibleToUser
        MLog.info("exposure", "setUserVisibleHint， HomeFragment userVisible = $userVisibleHint")
    }

    override fun onDestroy() {
        super.onDestroy()
        //解除View Presenter绑定
        presenter.destroy()
    }

    override fun refreshNavList(list: List<LiveNavInfo>) {
        MLog.info(TAG, "refreshNavList: list = $list")
        home_loading_progress.visibility = View.GONE
        val adapter = HomePagerAdapter(childFragmentManager)
        pager.adapter = adapter
        adapter.navList = list as MutableList<LiveNavInfo>
        adapter.notifyDataSetChanged()
        pager.offscreenPageLimit = 1
        pager.setCurrentItem(adapter.getSelectedPage(), true)
    }

    override fun showSubscribeTips(homeItemInfos: List<LiveInfoData>, subscribeLivingUid: ArraySet<Long>) {
        //
    }

    companion object {
        const val TAG = "HomeFragment"
    }
}