package com.yy.mobile.ui.homepage

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.widget.GridLayoutManager
import android.view.LayoutInflater
import android.view.MotionEvent
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.mainbean.LineDataMultiType
import com.yy.mobile.data.meipai.MPRecommendDialogData
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.logs.MLog
import com.yy.mobile.plugin.pluginunionhomepage.R
import com.yy.mobile.presenter.MultiLinePresenter
import com.yy.mobile.presenter.homepage.HomeContentPresenter
import com.yy.mobile.ui.viewholder.HomeContentAdapter
import com.yy.mobile.ui.viewholder.LiveModuleItemDecoration
import com.yy.mobile.ui.widget.RecommendAuthorDialog
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshLayout
import com.yy.mobile.ui.widget.smartrefreshlayout.listener.OnRefreshLoadMoreListener
import com.yy.mobile.utils.LoadType
import kotlinx.android.synthetic.main.hp_fragment_home_content.*

/**
 * Created by PYF on 2019/3/4
 */
open class HomeContentFragment : Fragment(), IHomeContentViewExtend {

    private lateinit var presenter: HomeContentPresenter
    private lateinit var rootView: View
    protected lateinit var navInfo: LiveNavInfo
    protected lateinit var subLiveNavInfo: SubLiveNavItem
    private var currentPosition: Int = -1

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        init(arguments)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.hp_fragment_home_content, null)
        presenter = HomeContentPresenter(this)
        return rootView
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        switchLoadingStatus(true)
        assignView()
    }

    private fun assignView() {
        initLayoutManager()
        initAdapter()
        rv_home_content_recyclerview.addItemDecoration(LiveModuleItemDecoration(20))
        //这里得区分一个哪里创建的HomeContent
        refreshHomepageData(LoadType.TOP_REFRESH)
        srl_home_refresh.setOnRefreshLoadmoreListener(object : OnRefreshLoadMoreListener {
            override fun onLoadMore(refreshlayout: RefreshLayout?) {
                Toast.makeText(context, "老哥我需要更多的数据", Toast.LENGTH_SHORT).show()
                loadMoreHomepageData()
            }

            override fun onRefresh(refreshlayout: RefreshLayout?) {
                Toast.makeText(context, "老哥我想刷新", Toast.LENGTH_SHORT).show()
                srl_home_refresh.finishRefresh(2000)
                refreshHomepageData(LoadType.TOP_REFRESH)
            }
        })
        no_data_icon.setOnClickListener {
            switchNoDataStatus(false)
            switchLoadingStatus(true)
            refreshHomepageData(LoadType.OVERTIME_REFRESH)
        }
    }

    private fun initStatistic() {
        //除了滚动时候要检测上报，还要首次加载的时候检查上报
        //同时应该还需要检查上一次停留的位置，防止重复上报
        //上报时候，还要检查vholder有百分之多少可见？
    }

    private fun initLayoutManager() {
        val layoutManager = GridLayoutManager(context, 2)
        layoutManager.spanSizeLookup = object : GridLayoutManager.SpanSizeLookup() {
            override fun getSpanSize(position: Int): Int {
                val item =
                    (rv_home_content_recyclerview.adapter as HomeContentAdapter).items[position] as LineDataMultiType
                return when (item.type) {
                    LivingCoreConstant.LIVING_TYPE_MOBILE_LIVE,
                    LivingCoreConstant.LIVING_TYPE_MOBILE_REPLAY,
                    LivingCoreConstant.LIVING_TYPE_SHOW_LIVE,
                    LivingCoreConstant.LIVING_TYPE_GAME_LIVE,
                    LivingCoreConstant.MP_LIVE_MODULE_CODE -> 1
                    else -> 2
                }
            }
        }
        rv_home_content_recyclerview.layoutManager = layoutManager
        rv_home_content_recyclerview.setOnTouchListener(object : View.OnTouchListener {

            var downTime: Long = 0

            override fun onTouch(v: View?, event: MotionEvent?): Boolean {
                when (event?.action) {
                    MotionEvent.ACTION_DOWN -> {
                        downTime = System.currentTimeMillis()
                        MLog.info(TAG, downTime.toString())
                    }
                    MotionEvent.ACTION_UP -> if (System.currentTimeMillis() - downTime <= 1000L) {
                        presenter.hasClick = true
                        MLog.info(TAG, "recyclerview perform clicked")
                        v?.performClick()
                    }
                }
                return false
            }

        })
        rv_home_content_recyclerview.setOnClickListener {
            presenter.hasClick = true
            MLog.info(TAG, "recyclerview has be clicked")
        }
    }

    fun refreshHomepageData(loadType: String) {
        presenter.requestHomePageData(loadType, navInfo, subLiveNavInfo)
        presenter.requestRecommendAuthor()
    }

    override fun refreshOrAddRecyclerView(refresh: Boolean, list: List<LineDataMultiType>) {
        val adapter = rv_home_content_recyclerview.adapter as HomeContentAdapter
        if (refresh) {
            adapter.items = list
            adapter.notifyDataSetChanged()
        } else {
            val size = adapter.items.size
            adapter.addItems(list)
            adapter.notifyItemInserted(size)
        }
    }

    fun loadMoreHomepageData() {
        presenter.requestMoreHomePageData()
    }

    override fun finishRefreshAnimation(isLoadMore: Boolean, delayed: Int) {
        if (isLoadMore) {
            srl_home_refresh.finishLoadmore(delayed)
        } else {
            srl_home_refresh.finishRefresh(delayed)
        }
    }

    override fun switchLoadingStatus(visible: Boolean) {
        loading_progress.visibility = if (visible) View.VISIBLE else View.GONE
        srl_home_refresh.visibility = if (visible) View.INVISIBLE else View.VISIBLE
    }

    override fun switchNoDataStatus(visible: Boolean) {
        no_data_icon.visibility = if (visible) View.VISIBLE else View.GONE
        srl_home_refresh.visibility = if (visible) View.INVISIBLE else View.VISIBLE
    }

    override fun onDestroy() {
        super.onDestroy()
        presenter.destroy()
    }

    override fun showRecommendAuthorDialog(dialogData: MPRecommendDialogData) {
        MLog.info(TAG, "showRecommendAuthorDialog: $dialogData")

        val dialog = RecommendAuthorDialog()
        dialog.setDialogData(dialogData)
        dialog.show(activity?.fragmentManager, "RecommendAuthorDialog")
    }

    private fun init(
        bundle: Bundle?
    ) {
        bundle?.let {
            this.navInfo = it.getParcelable(KEY_NAV_INFO)
            this.subLiveNavInfo = it.getParcelable(KEY_SUB_NAV_INFO)
            this.currentPosition = it.getInt(KEY_POSITION_IN_PARENT)
        }
    }

    open fun initAdapter() {
        rv_home_content_recyclerview.adapter = HomeContentAdapter(MultiLinePresenter()
            .navInfo(navInfo)
            .subNavBiz(subLiveNavInfo.biz)
            .fromType(TAG),
            "")
    }

    companion object {
        const val TAG = "HomeContentFragment"
        const val KEY_NAV_INFO = "key_nav_info"
        const val KEY_SUB_NAV_INFO = "key_sub_nav_info"
        const val KEY_POSITION_IN_PARENT = "key_position_in_parent"

        fun newInstance(
            navInfo: LiveNavInfo,
            subLiveNavItem: SubLiveNavItem,
            position: Int
        ): HomeContentFragment {
            val fragment = HomeContentFragment()
            val bundle = Bundle()
            bundle.putParcelable(KEY_NAV_INFO, navInfo)
            bundle.putParcelable(KEY_SUB_NAV_INFO, subLiveNavItem)
            bundle.putInt(KEY_POSITION_IN_PARENT, position)
            fragment.arguments = bundle
            return fragment
        }
    }
}