package com.yy.mobile.ui.follow

import android.content.Context
import android.view.View
import android.view.ViewStub
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.plugin.pluginunionhomepage.R

/**
 * User: miaodingfan
 * Date: 2019/1/21
 */
class LiveNoticeTipsLayout {

    var layout:View
    var portraitList: ArrayList<ImageView>
    var tipTxt: TextView
    var context: Context


    constructor(stubId:Int, rootView: View){
        val viewStub = rootView.findViewById<ViewStub>(stubId)
        layout = viewStub.inflate()
        portraitList = ArrayList<ImageView>(3)
        portraitList.add(layout.findViewById(R.id.tips_portrait1))
        portraitList.add(layout.findViewById(R.id.tips_portrait2))
        portraitList.add(layout.findViewById(R.id.tips_portrait3))
        tipTxt = layout.findViewById(R.id.tips_txt)
        context = rootView.context
    }


    fun show(infos: List<LiveInfoData>){
        layout.visibility = View.VISIBLE
        tipTxt.text = tipTxt.context.getString(R.string.hp_live_notice_tips, infos.size)
        for(i in 0..portraitList.size){
            if(i >= infos.size && portraitList.size > i){
                portraitList[i].visibility = View.GONE
            } else if (portraitList.size > i){
                portraitList[i].visibility = View.VISIBLE
                Glide.with(context).load(infos[i].avatar).apply(RequestOptions().placeholder(R.drawable.hp_default_portrait)).into(portraitList[i])
            }
        }
    }
    
    fun hide(){
        layout.visibility = View.GONE
    }



}