package com.yy.mobile.ui.follow

import android.os.Bundle
import android.view.View
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.presenter.MultiLinePresenter
import com.yy.mobile.ui.homepage.HomeContentFragment
import com.yy.mobile.ui.viewholder.HomeContentAdapter
import kotlinx.android.synthetic.main.hp_fragment_home_content.*

class FollowContentFragment : HomeContentFragment() {

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
//        srl_home_refresh.isEnableLoadmore = false
    }

    //修改下
    override fun initAdapter() {
        super.initAdapter()
        rv_home_content_recyclerview.adapter = HomeContentAdapter(MultiLinePresenter()
                .navInfo(navInfo)
                .subNavBiz(subLiveNavInfo.biz)
                .fromType(TAG),
                "")
    }

    companion object {
        const val TAG = "FollowContentFragment"
        const val KEY_NAV_INFO = "key_nav_info"
        const val KEY_SUB_NAV_INFO = "key_sub_nav_info"
        const val KEY_POSITION_IN_PARENT = "key_position_in_parent"

        fun newInstance(
                navInfo: LiveNavInfo,
                subLiveNavItem: SubLiveNavItem,
                position: Int
        ): HomeContentFragment {
            val fragment = HomeContentFragment()
            val bundle = Bundle()
            bundle.putParcelable(KEY_NAV_INFO, navInfo)
            bundle.putParcelable(KEY_SUB_NAV_INFO, subLiveNavItem)
            bundle.putInt(KEY_POSITION_IN_PARENT, position)
            fragment.arguments = bundle
            return fragment
        }
    }
}