package com.yy.mobile.statistic

import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
/**
 * @author zhengyongxin
 * @date 创建时间: 2018/9/5
 * @Description 使用构建者模式封装模块数据上报需要使用的数据
 * 模块统一必须的参数请添加到构建器中，非统一必须的请添加到普通字段中，并在构建器apply中为其赋值
 */
class VHolderHiidoInfo constructor(
        var navInfo: LiveNavInfo?,
        var subNavBiz: String?,
        var from: String?,
//        var moduleType: Int,
        var moduleId: Int
) {
    var contentId: Int = 0
    var position: Int = 0
    var sid: Long = 0L
    var ssid: Long = 0L
    var uid: Long = 0L
    var token: String? = null
    var contentType: Int = 0
    var moduleStyle: String? = null
    var isBrightLabel: Int = 0
    var isVideoPlaying: Int = 0
    var title: String? = ""

    class Builder constructor(
        var navInfo: LiveNavInfo?,
        var subNavBiz: String?,
        var from: String?,
//        var moduleType: Int,
        var moduleId: Int
    ) {
        var contentId: Int = 0
        var position: Int = 0
        var sid: Long = 0L
        var ssid: Long = 0L
        var uid: Long = 0L
        var token: String? = null
        var contentType: Int = 0
        var moduleStyle: String? = null
        var isBrightLabel: Int = 0
        var isVideoPlaying: Int = 0
        var title: String? = ""

        fun contentId(contentId: Int): Builder {
            return this.apply {
                this.contentId = contentId
            }
        }

        fun position(position: Int): Builder {
            return this.apply {
                this.position = position
            }
        }

        fun sid(sid: Long): Builder {
            return this.apply {
                this.sid = sid
            }
        }

        fun ssid(ssid: Long): Builder {
            return this.apply {
                this.ssid = ssid
            }
        }

        fun uid(uid: Long): Builder {
            return this.apply {
                this.uid = uid
            }
        }

        fun token(token: String?): Builder {
            return this.apply {
                this.token = token
            }
        }

        fun contentType(contentType: Int): Builder {
            return this.apply {
                this.contentType = contentType
            }
        }

        fun moduleStyle(moduleStyle: String?): Builder {
            return this.apply {
                this.moduleStyle = moduleStyle
            }
        }

        fun isBrightLabel(isBrightLabel: Int): Builder {
            return this.apply {
                this.isBrightLabel = isBrightLabel
            }
        }

        fun isVideoPlaying(isVideoPlaying: Int): Builder {
            return this.apply {
                this.isVideoPlaying = isVideoPlaying
            }
        }

        fun title(title: String?): Builder {
            return this.apply {
                this.title = title
            }
        }

        fun create(): VHolderHiidoInfo {
            return VHolderHiidoInfo(
                navInfo,
                subNavBiz,
                from,
//                moduleType,
                moduleId
            ).apply {
                this.contentId = this@Builder.contentId
                this.position = this@Builder.position
                this.sid = this@Builder.sid
                this.ssid = this@Builder.ssid
                this.uid = this@Builder.uid
                this.token = this@Builder.token
                this.contentType = this@Builder.contentType
                this.moduleStyle = this@Builder.moduleStyle
                this.isBrightLabel = this@Builder.isBrightLabel
                this.isVideoPlaying = this@Builder.isVideoPlaying
                this.title = this@Builder.title
            }
        }
    }
}