package com.yy.mobile.statistic

import com.yy.hiidostatis.api.HiidoSDK
import com.yy.hiidostatis.defs.obj.Property
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.logs.MLog
import com.yy.mobile.utils.FP
import com.yy.mobile.utils.LoginUtil

object HiidoReportHelper {

    var currentFragmentVisible = true

    //抄袭来的一个数据上报
    private fun report(uid: Long, eventId: String?, label: String?, properties: Map<String, String>?) {
        MLog.info("HiidoReportHelper", "report: uid = $uid, eventId = $eventId, " +
            "labelId = $label, properties = $properties")
        HiidoSDK.instance().reportTimesEvent(uid, eventId, label, Property().apply {
            properties?.forEach { this.putString(it.key, it.value) }
        })
        //还有一个老铁方的数据上报，这个不是很确定
        //等着补充
    }

    private fun report(eventId: String?, label: String?, properties: Map<String, String>?) {
        HiidoReportHelper.report(LoginUtil.getUid().toLong(), eventId, label, properties)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030619
     * APP-点击事件-列表页-10301-页面行为-0001-进入列表页
     */
    fun sendLiveNavExposure(navInfo: LiveNavInfo?) {
        navInfo?.apply {
            val map = HashMap<String, String>()
            map["key1"] = "" + biz
            report("10301", "0001", map)
        }
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030621
     * APP-点击事件-列表页-10301-页面行为-0002-页面内容曝光 （含HMI混流推荐页）
     *
     */
    private fun sendHPVHolderExposure(info: VHolderHiidoInfo) {

        /**
         * 加载列表	key1	string
         * 主播uid_频道id#，各参数均后端统一ID，无则在对应位置默认留空，如有多个请用#分隔
         */
        fun VHolderHiidoInfo.buildKey1(): String {
            return java.lang.StringBuffer().apply {
                append(if (info.uid != 0L) info.uid else "")
                append("_")
                append(if (info.sid != 0L) info.sid else "")
                append("#")
            }.toString()
        }

        /**
         * 页面id	key3	string
         */
        fun VHolderHiidoInfo.buildKey3(): String {
            return HiidoReportHelper.getPageId(navInfo?.biz, subNavBiz) ?: ""
        }

        /**
         * 位置   	key4	string
         */
        fun VHolderHiidoInfo.buildKey4(): String {
            return position.toString()
        }

        /**
         * 模块ID   	key5	string
         */
        fun VHolderHiidoInfo.buildKey5(): String {
            return ""
        }

        /**
         * token Id   	key6	string
         */
        fun VHolderHiidoInfo.buildKey6(): String {
            return token ?: ""
        }

        val map = HashMap<String, String>()
        map.put("key1", info.buildKey1())
        map.put("key3", info.buildKey3())
        map.put("key5", info.buildKey4())
        map.put("key5", info.buildKey5())
        map.put("key6", info.buildKey6())

        report("10301", "0002", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030623
     * APP-点击事件-列表页-10301-页面行为-0003-页面内容点击 （含MI混流推荐页）
     *
     */
    fun sendHPVHolderClick(info: VHolderHiidoInfo) {
        /**
         * 直播间id
         */
        fun VHolderHiidoInfo.buildKey1(): String {
            if (sid != 0L) {
                return "" + sid
            }
            if (ssid != 0L) {
                return "" + ssid
            }
            return ""
        }

        /**
         * 主播uid
         */
        fun VHolderHiidoInfo.buildKey2(): String {
            return if (uid != 0L) {
                uid.toString()
            } else {
                ""
            }
        }

        /**
         * 模块内容id
         */
        fun VHolderHiidoInfo.buildKey3(): String {
            return ""
        }

        /**
         * 页面id
         */
        fun VHolderHiidoInfo.buildKey5(): String {
            return getPageId(navInfo?.biz, subNavBiz) ?: ""
        }

        /**
         * 位置id
         */
        fun VHolderHiidoInfo.buildKey6(): String {
            return if (position != -1) {
                position.toString()
            } else {
                ""
            }
        }

        /**
         * token id
         */
        fun VHolderHiidoInfo.buildKey7(): String {
            return token ?: ""
        }

        val map = HashMap<String, String>()
        map.put("key1", info.buildKey1())
        map.put("key2", info.buildKey2())
        map.put("key3", info.buildKey3())
        map.put("key5", info.buildKey5())
        map.put("key6", info.buildKey6())
        map.put("key7", info.buildKey7())

        report("10301", "0003", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030649
     * APP-点击事件-列表页-10302-二级页面-0004-二级分类页面内容点击）
     */
    fun sendMoreVHolderClick(pageId: String?, sid: Long, uid: Long) {
        val map = HashMap<String, String>()
        if (pageId == null) {
            map.put("key1", "")
        } else {
            map.put("key1", "" + pageId)
        }
        map.put("key2", "" + sid)
        map.put("key3", "" + uid)
        report("10302", "0004", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030645
     * APP-点击事件-列表页-10302-二级页面-0002-二级分类点击
     */
    fun sendSubItemClick(pageId: String?) {
        val map = HashMap<String, String>()
        if (pageId == null) {
            map.put("key1", "")
        } else {
            map.put("key1", "" + pageId)
        }
        report("10302", "0002", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030647
     * APP-点击事件-列表页-10302-二级页面-0003-二级分类页面内容曝光
     */
    fun sendMoreVHolderExposure(info: VHolderHiidoInfo) {

        /**
         * 页面id  key1  String
         */
        fun VHolderHiidoInfo.buildKey1(): String {
            return HiidoReportHelper.getPageId(navInfo?.biz, subNavBiz) ?: ""
        }

        /**
         * 频道id key2  String
         */
        fun VHolderHiidoInfo.buildKey2(): String {
            if (sid != 0L) {
                return "" + sid
            }
            if (ssid != 0L) {
                return "" + ssid
            }
            return ""
        }

        /**
         * 主播uid key3  String
         */
        fun VHolderHiidoInfo.buildKey3(): String {
            return if (uid != 0L) {
                uid.toString()
            } else {
                ""
            }
        }

        val map = HashMap<String, String>()
        map.put("key1", info.buildKey1())
        map.put("key2", info.buildKey2())
        map.put("key3", info.buildKey3())

        report("10302", "0003", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030643
     * APP-点击事件-列表页-10302-二级页面-0001-二级分类曝光
     */
    fun sendTagVHolderExposure(navInfo: LiveNavInfo, subNavInfo: SubLiveNavItem) {
        val map = HashMap<String, String>()
        map.put("key1", HiidoReportHelper.getPageId(navInfo.biz, subNavInfo.biz) ?: "")
        report("10302", "0001", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030625
     * APP-点击事件-直播通知-10401-直播通知-0001-进入直播通知
     */
    fun sendSubscribeBtnClick() {
        report("10401", "0001", null)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030627
     * APP-点击事件-直播动态-10501-直播动态-0001-直播动态内容曝光
     */
    fun sendSubscribeVHolderExposure(info: VHolderHiidoInfo) {
        val map = HashMap<String, String>()
        map.put("key1", "" + info.uid)
        report("10501", "0001", map)
    }

    /**
     * https://data.hiido.com/index.php?r=sdkdemand/eventview&id=20030629
     * APP-点击事件-直播动态-10501-直播动态-0002-直播动态内容点击
     */
    fun sendSubscribeItemClick(uid: Long, sid: Long) {
        val map = HashMap<String, String>()
        map.put("key1", "" + uid)
        map.put("key2", "" + sid)
        report("10501", "0002", map)
    }

    fun getPageId(navInfoBiz: String?, subNavInfoBiz: String?): String? {
        if (navInfoBiz == null) {
            return ""
        }
        if (subNavInfoBiz == null) {
            return navInfoBiz
        }
        return if (LivingCoreConstant.LIVE_URL_FIXED_IDX_STR == subNavInfoBiz)
            navInfoBiz
        else
            navInfoBiz + "_" + subNavInfoBiz
    }

    //token
    fun getRecommendField(token: String, recommend: Int): String {
        val str: String
        if (FP.empty(token)) {
            str = recommend.toString()
        } else {
            str = token
        }
        return str
    }

    fun exposure() {
        //把这个函数假想成曝光函数
        if (!currentFragmentVisible) {
            return
        }
    }
}