package com.yy.mobile.presenter.homepage

import android.support.v4.util.ArraySet
import com.google.gson.Gson
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.LiveNavRowData
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.logs.MLog
import com.yy.mobile.model.HomepageDataModule
import com.yy.mobile.ui.homepage.IHomeView
import com.yy.mobile.utils.LoadType
import com.yy.mobile.utils.LoginUtil
import com.yy.mobile.utils.RxUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

/**
 * Created by PYF on 2019/3/4
 */

class HomeFragmentPresenter(private var view: IHomeView?) {

    private var module: HomepageDataModule = HomepageDataModule()
    var hasShowSubscribeTips: Boolean = false
    private val disposable: CompositeDisposable = CompositeDisposable()

    fun requestNavData() {
        disposable.add(module.requestHomepageNavInfo()
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({
                if (it.data.isEmpty()) {
                    view?.refreshNavList(localNavs())
                } else {
                    view?.refreshNavList(it.data)
                }
            }, {
                MLog.error(TAG, "requestNavData: error = ${it.localizedMessage}")
                view?.refreshNavList(localNavs())
            }))
    }

    fun mpRequestNavData() {
        view?.refreshNavList(mpAssumeNavs())
    }

    fun requestSubscribeInfo() {
        if (LoginUtil.isLogined() && !hasShowSubscribeTips) {
            //随便用的一个LoadType
            disposable.add(module.requestSubscribeData(LiveNavInfo(2, "subscribe"), SubLiveNavItem(2, "idx"),
                if (hasShowSubscribeTips) LoadType.TOP_REFRESH else LoadType.APP_BOOT)
                .map {
                    return@map it.data[0]
                }
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    if (it.data.isNotEmpty() && it.data[0] is LiveInfoData) {
                        val uidSet = ArraySet<Long>()
                        it.data.forEach {
                            uidSet.add((it as LiveInfoData).uid)
                        }
                        view?.showSubscribeTips(it.data as List<LiveInfoData>, uidSet)
                    }
                }, RxUtils.errorConsumer(TAG)))
        } else {
            MLog.info(TAG,
                "requestSubscribeInfo: ${LoginUtil.isLogined()}, hasShowSubscribeTips = $hasShowSubscribeTips")
        }
    }

    fun localNavs(): List<LiveNavInfo> {
        val local =
            "{\"code\":0,\"message\":\"success\",\"data\":[{\"id\":76,\"name\":\"推荐\"," +
                "\"platform\":11,\"biz\":\"index\",\"url\":\"\",\"sort\":10,\"selected\":1," +
                "\"pic\":\"\"},{\"id\":79,\"name\":\"歌舞\",\"platform\":11,\"biz\":\"singdance\"," +
                "\"url\":\"\",\"sort\":9,\"selected\":0,\"pic\":\"\"},{\"id\":78,\"name\":\"户外\"," +
                "\"platform\":11,\"biz\":\"outdoor\",\"url\":\"\",\"sort\":8,\"selected\":0,\"pic\":" +
                "\"\"},{\"id\":77,\"name\":\"脱口秀\",\"platform\":11,\"biz\":\"talk\",\"url\":\"\"," +
                "\"sort\":7,\"selected\":0,\"pic\":\"\"}]}"
        val rowData = Gson().fromJson(local, LiveNavRowData::class.java)
        return rowData.data
    }

    private fun mpAssumeNavs(): List<LiveNavInfo> {
        return listOf(LiveNavInfo(0, "yylive"))
    }

    //总感觉这样傻傻的。可以用继承解决
    fun destroy() {
        view = null
        disposable.dispose()
    }

    companion object {
        const val TAG = "HomeFragmentPresenter"
    }
}