package com.yy.mobile.model

import com.google.gson.GsonBuilder
import com.google.gson.reflect.TypeToken
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.constant.UrlSettings
import com.yy.mobile.data.main.BaseNetData
import com.yy.mobile.data.main.HomepageData
import com.yy.mobile.data.main.LineData
import com.yy.mobile.data.meipai.MPBaseNetData
import com.yy.mobile.data.meipai.MPLineData
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.LiveNavRowData
import com.yy.mobile.data.nav.SubLiveNavItem
import com.yy.mobile.http.*
import com.yy.mobile.logs.MLog
import com.yy.mobile.utils.LoadType
import com.yy.mobile.utils.RequestParamsUtil
import io.reactivex.Observable
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import retrofit2.converter.gson.GsonConverterFactory

/**
 * Created by PYF on 2019/3/1
 * 假设这个是首页的数据中心模块
 */
class HomepageDataModule {

    fun requestHomepageNavInfo(): Observable<LiveNavRowData> {
        val retrofit = buildRetrofit(
            UrlSettings.LIVING_NAV_INFO,
            GsonConverterFactory.create()
        )

        val service = retrofit.create(IHomepageDataService::class.java)
        return service.getHomepageNavInfo(RequestParamsUtil.paramMap(null, null))
    }

    fun requestHomapageData(
        loadType: String,
        navInfo: LiveNavInfo?,
        subNavInfo: SubLiveNavItem?
    ): Observable<BaseNetData> {
        val listType = object : TypeToken<LineData<HomepageData>>() {}.type
        val gson = GsonBuilder().registerTypeAdapter(listType, HomepageDataJsonAdapter()).create()
        val retrofit = buildRetrofit(
            LivingCoreConstant.getServerUrl(navInfo, subNavInfo),
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IHomepageDataService::class.java)
        return service.getHomepageData(RequestParamsUtil.paramMap(loadType, null))
    }

    fun requestMPHomepageData(
        loadType: String,
        navInfo: LiveNavInfo?,
        subNavInfo: SubLiveNavItem?
    ): Observable<MPBaseNetData> {
        val listType = object : TypeToken<MPLineData<com.yy.mobile.data.base.HomepageData>>() {}.type
        val gson = GsonBuilder().registerTypeAdapter(listType, MPHomepageDataJsonAdapter()).create()
        val retrofit = buildRetrofit(
            LivingCoreConstant.getServerUrl(navInfo, subNavInfo),
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IMPHomepageDataService::class.java)
        return service.getHomepageData(RequestParamsUtil.paramMap(loadType, null))
    }

    fun requestMoreHomepageData(
        navInfo: LiveNavInfo?,
        subNavInfo: SubLiveNavItem?,
        pageNo: Int,
        moduleId: Int
    ): Observable<BaseNetData> {
        val listType = object : TypeToken<MPLineData<com.yy.mobile.data.base.HomepageData>>() {}.type
        val gson = GsonBuilder()
            .registerTypeAdapter(BaseNetData::class.java, BaseNetDataErrorJsonAdapter())
            .registerTypeAdapter(listType, HomepageDataJsonAdapter())
            .create()
        val retrofit = buildRetrofit(
            LivingCoreConstant.getServerUrl(navInfo, subNavInfo, moduleId, pageNo),
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IHomepageDataService::class.java)
        return service.getMoreHomepageData(RequestParamsUtil.paramMap(LoadType.TOP_REFRESH, pageNo))
    }

    fun requestMPMoreHomepageData(lineData: MPLineData<com.yy.mobile.data.base.HomepageData>): Observable<MPBaseNetData> {
        val listType = object : TypeToken<MPLineData<com.yy.mobile.data.base.HomepageData>>() {}.type
        val gson = GsonBuilder()
            .registerTypeAdapter(MPBaseNetData::class.java, MoreHomepageDataJsonAdapter())
            .registerTypeAdapter(listType, MPHomepageDataJsonAdapter())
            .create()
        val retrofit = buildRetrofit(
            LivingCoreConstant.getMoreServerUrl(lineData),
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IMPHomepageDataService::class.java)
        return service.getMoreHomepageData(RequestParamsUtil.paramMap(null, lineData.page))
    }

    fun requestSubscribeData(
        navInfo: LiveNavInfo?,
        subNavInfo: SubLiveNavItem?,
        loadType: String
    ): Observable<BaseNetData> {
        val listType = object : TypeToken<MPLineData<com.yy.mobile.data.base.HomepageData>>() {}.type
        val gson = GsonBuilder().registerTypeAdapter(listType, HomepageDataJsonAdapter()).create()
        val retrofit = buildRetrofit(
            LivingCoreConstant.getServerUrl(navInfo, subNavInfo),
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IHomepageDataService::class.java)
        return service.getHomepageData(RequestParamsUtil.paramMap(loadType, -1))
    }

    fun requestRecommendAuthor(): Observable<MPBaseNetData> {
        val listType = object : TypeToken<MPLineData<com.yy.mobile.data.base.HomepageData>>() {}.type
        val gson = GsonBuilder().registerTypeAdapter(listType, MPHomepageDataJsonAdapter()).create()
        val retrofit = buildRetrofit(
            UrlSettings.RECOMMEND_AUTHOR_POPUP_DIALOG,
            GsonConverterFactory.create(gson)
        )

        val service = retrofit.create(IMPHomepageDataService::class.java)
        return service.getRecommendAuthor(RequestParamsUtil.paramMap("", null))
    }

    private fun buildRetrofit(baseUrl: String, factory: GsonConverterFactory) =
        Retrofit.Builder()
            .baseUrl(baseUrl)
            .client(okClient)
            .addConverterFactory(factory)
            .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
            .build()

    companion object {
        private val interceptor = HttpLoggingInterceptor(
            HttpLoggingInterceptor.Logger { message -> MLog.info(TAG, "retrofitCallback = $message") })

        init {
            interceptor.level = HttpLoggingInterceptor.Level.BODY
        }

        const val TAG = "HomepageDataModule"
        val okClient: OkHttpClient = OkHttpClient.Builder().addInterceptor(interceptor).build()
    }
}