package com.yy.mobile.logs

import com.yy.mobile.api.HPLogCallback
import tv.athena.klog.api.KLog

/**
 * Created BY PYF 2019/6/3
 * email: pengyangfan@yy.com
 */
object MLog {

    var sLogHandler: HPLogCallback? = null

    fun verbose(obj: Any, format: String, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.v(obj.toString(), format, *args)
        } else {
            sLogHandler?.verbose(obj.toString(), format, *args)
        }
    }

    fun debug(obj: Any, format: String, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.d(obj.toString(), format, *args)
        } else {
            sLogHandler?.debug(obj.toString(), format, *args)
        }
    }

    fun info(obj: Any, format: String, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.i(obj.toString(), format, *args)
        } else {
            sLogHandler?.info(obj.toString(), format, *args)
        }
    }

    fun warn(obj: Any, format: String, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.w(obj.toString(), format, *args)
        } else {
            sLogHandler?.warn(obj.toString(), format, *args)
        }
    }

    fun error(obj: Any, format: String, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.e(obj.toString(), format, *args)
        } else {
            sLogHandler?.error(obj.toString(), format, *args)
        }
    }

    fun error(obj: Any, format: String, t: Throwable, vararg args: Any) {
        if (sLogHandler == null) {
            KLog.e(obj.toString(), format, t, *args)
        } else {
            sLogHandler?.error(obj.toString(), format, t, *args)
        }
    }

    fun error(obj: Any, t: Throwable) {
        if (sLogHandler == null) {
            KLog.e(obj.toString(), "", t)
        } else {
            sLogHandler?.error(obj.toString(), "", t)
        }
    }
}