package com.yy.mobile.logs

import android.content.Context
import com.yy.mobile.api.HPLogCallback
import tv.athena.core.axis.Axis
import tv.athena.klog.api.ILogService
import tv.athena.klog.api.LogLevel
import tv.athena.util.FP
import tv.athena.util.ProcessorUtils
import tv.athena.util.RuntimeInfo
import java.io.File

/**
 * Created by PYF on 2019/3/6
 */

class LoggerInitTask {
    /**
     * 不提供log实现的话，则调用这个
     */
    fun initLogging(context: Context) {
        BasicConfig.mInstance.run {
            setRoot(Constants.Host.YYMOBILE_DIR_NAME)
            setConfigDir(Constants.Host.YYMOBILE_DIR_NAME + File.separator + "config")
            setLogDir()
        }
        if (MLog.sLogHandler == null) {
            initKlog(context)
        }
    }

    /**
     * 正常的话设置这个handler就够了，
     * 跨进城最好还是自己打印日志
     */
    fun initLogging(logHandler: HPLogCallback) {
        MLog.sLogHandler = logHandler
    }

    private fun initKlog(context: Context) {
        /**
         * 设置全局context
         * */
        RuntimeInfo.appContext(context)
            /**
             * 设置包名
             * */
            .packageName(BasicConfig.mInstance.mPackageName)
            /**
             * 保存进程名
             * */
            .processName(ProcessorUtils.getMyProcessName() ?: "")
            /**
             * 设置是否是debug 模式
             * */
            .isDebuggable(true)
            /**
             * 保存当前进程是否是主进程
             * */
            .isMainProcess(FP.eq(RuntimeInfo.sPackageName, RuntimeInfo.sProcessName))


        /**
         * 初始化 KLog  现在是默认配置
         * */
        Axis.getService(ILogService::class.java)!!.config()
            /**
             * 设置日志写入级别
             */
            .logLevel(LogLevel.LEVEL_INFO)
            /**
             * 单个log文件最大值
             */
            .singleLogMaxSize(4 * 1024 * 1024)
            /**
             * 设置进程标识
             * */
            .processTag(RuntimeInfo.sProcessName ?: "")
            /**
             * 想法是日志输出
             */
            .logPath(BasicConfig.mInstance.getLogDirPath())
            /**
             * 设置存储日志内存上限
             */
            .logCacheMaxSiz((100 * 1024 * 1024).toLong()).apply()
    }

    companion object {
        const val TAG = "LoggerInitTask"
    }
}