package com.yy.mobile.logs

import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.os.Environment
import com.yy.mobile.utils.ContextHolder
import com.yy.mobile.utils.FP
import java.io.File

/**
 * Created by PYF on 2019/3/6
 * 毫无水平的搬运，都不知道哪里会出问题
 */

class BasicConfig private constructor() {

    private val yyMobileDir = "tieyy"
    private val yyLogsDir = "logs"
    private val yySdkLogsDir = "sdklog"
    private var mRoot: File? = null
    private var mConfigDir: File? = null
    private var mLogDir: File? = null
    private var mSdkLogDir: File? = null
    val mPackageName = "com.unionyy"

    companion object {
        const val TAG = "BasicConfig"
        val mInstance: BasicConfig by lazy { BasicConfig() }
    }

    fun getCacheDir(context: Context, uniqueName: String): File {
        val cachePath: String
        if (Environment.MEDIA_MOUNTED == Environment.getExternalStorageState() && hasExternalStoragePermission(
                context) &&
            (isExternalStorageAvailable() || !isExternalStorageRemovable())) {
            cachePath = getExternalCacheDir().path
        } else {
            cachePath = context.cacheDir.path
        }
        return File(cachePath + File.separator + uniqueName)
    }

    fun setRoot(dirName: String) {
        val f = getCacheDir(ContextHolder.instance.applicationContext!!, yyMobileDir)
        if (!f.exists()) {
            f.mkdirs()
        }
        this.mRoot = f
    }

    fun setConfigDir(dir: String) {
        try {
            mConfigDir = getCacheDir(ContextHolder.instance.applicationContext!!, dir)
            if (!mConfigDir!!.exists()) {
                if (!mConfigDir!!.mkdirs()) {
                    MLog.error(TAG, "Can't create config dir $mConfigDir")
                    return
                }
            }
        } catch (e: Exception) {
            MLog.error(TAG, "Set config dir error", e)
        }
    }

    /**
     * 设置log的目录
     */
    fun setLogDir() {
        try {
            if (mLogDir != null && mLogDir!!.exists()) {
                MLog.info(TAG, "log dir " + mLogDir!!.getAbsolutePath())
                return
            }
            var cacheDirectory = getCacheDir(ContextHolder.instance.applicationContext!!, yyMobileDir)
            //File cacheDirectory = StorageUtils.getCacheDirectory(mContext);
            if (!cacheDirectory.exists()) {
                cacheDirectory.mkdirs()
            }
            if (cacheDirectory.exists()) {
                mLogDir = File(cacheDirectory.getAbsolutePath() + File.separator + yyLogsDir)
                //是否有效
                if (!mLogDir!!.exists()) {
                    if (!mLogDir!!.mkdirs()) {
                        MLog.error(TAG, "Can't create log dir ")
                    }
                }
            }

            //文件是否可以写
            if (mLogDir!!.exists() && !mLogDir!!.canWrite()) {
                cacheDirectory =
                    File(ContextHolder.instance.applicationContext!!.cacheDir.path + File.separator + yyMobileDir)
                if (!cacheDirectory.exists()) {
                    cacheDirectory.mkdirs()
                }
                if (cacheDirectory.exists()) {
                    mLogDir = File(cacheDirectory.getAbsolutePath() + File.separator + yyLogsDir)
                    //是否有效
                    if (!mLogDir!!.exists()) {
                        if (!mLogDir!!.mkdirs()) {
                            MLog.error(TAG, "Can't create log dir ")
                        }
                    }
                }
            }
            MLog.info(TAG, "create mLogDir dir $mLogDir")
        } catch (e: Throwable) {
            MLog.error(TAG, "Set log dir error", e)
        }
    }

    //
    private fun isExternalStorageRemovable(): Boolean {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
            Environment.isExternalStorageRemovable()
        } else true
    }

    private fun isExternalStorageAvailable(): Boolean {
        return false
    }

    //
    private fun getExternalCacheDir(): File {
        return File(Environment.getExternalStorageDirectory().path)
    }

    //
    private fun hasExternalStoragePermission(context: Context): Boolean {
        val perm = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE")
        return perm == PackageManager.PERMISSION_GRANTED
    }

    fun getLogDirPath(): String {
        val logDir = getLogDir()
        return if (logDir == null || FP.empty(logDir.absolutePath)) {
            "/storage/emulated/0/$yyMobileDir/$yyLogsDir"
        } else logDir.absolutePath
    }

    private fun getLogDir(): File? {
        try {
            if (mLogDir == null) {
                setLogDir()
            }
        } catch (e: Throwable) {
            MLog.error(TAG, "getLogDir log dir error", e)
        }

        return mLogDir
    }

    fun getSDKLogDirPath(): String {
        val sdkLogDir = getSDKLogDir()
        return if (sdkLogDir == null || FP.empty(sdkLogDir.absolutePath)) {
            "/storage/emulated/0/$yyMobileDir/$yyLogsDir/$yySdkLogsDir"
        } else sdkLogDir.absolutePath
    }

    private fun getSDKLogDir(): File? {
        try {
            if (mSdkLogDir == null) {
                setSDKLogDir()
            }
        } catch (e: Throwable) {
            MLog.error(TAG, "getLogDir log dir error", e)
        }

        return mSdkLogDir
    }

    fun setSDKLogDir() {
        try {
            if (mSdkLogDir != null && mSdkLogDir!!.exists()) {
                MLog.info(TAG, "mSdkLogDir dir " + mSdkLogDir!!.absolutePath)
                return
            }
            val logDirFile = getLogDir()
            mSdkLogDir = File(logDirFile.toString() + File.separator + yySdkLogsDir)
            //是否有效
            if (!mSdkLogDir!!.exists()) {
                if (!mSdkLogDir!!.mkdirs()) {
                    MLog.error(TAG, "Can't create log dir ")
                }
            }
            MLog.info(TAG, "create mSdkLogDir dir $mSdkLogDir")
        } catch (e: Throwable) {
            MLog.error(TAG, "Set log dir error", e)
        }
    }
}