package com.yy.mobile.http

import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.yy.mobile.data.base.HomepageData
import com.yy.mobile.data.meipai.MPBaseNetData
import com.yy.mobile.data.meipai.MPLineData
import com.yy.mobile.data.meipai.MPLiveInfoData
import java.lang.reflect.Type

/**
 * Created by liyang
 * on 2019-08-14
 */
class MoreHomepageDataJsonAdapter : JsonDeserializer<MPBaseNetData> {

    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): MPBaseNetData {
        val jsonObj = json?.asJsonObject
        val data = jsonObj?.get("data")

        if (data?.isJsonArray == false) {
            val listType = object : TypeToken<MPLineData<MPLiveInfoData>>() {}.type
            val lineData: MPLineData<MPLiveInfoData> = Gson().fromJson(data, listType)
            return MPBaseNetData().apply {
                this.data.add(lineData as MPLineData<HomepageData>)
            }
        }
        return Gson().fromJson(json, MPBaseNetData::class.java)
    }
}