package com.yy.mobile.http

import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.base.HomepageData
import com.yy.mobile.data.meipai.*
import java.lang.reflect.Type

/**
 * Created BY PYF 2019/6/5
 * email: pengyangfan@yy.com
 * 这个要想办法做成注解生成
 */
class MPHomepageDataJsonAdapter : JsonDeserializer<MPLineData<HomepageData>> {

    override fun deserialize(
            json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?
    ): MPLineData<HomepageData> {
        val jsonObj = json?.asJsonObject
        when (jsonObj?.get("type")?.asInt) {
            LivingCoreConstant.MP_LIVE_MODULE_BANNER_CODE,
            LivingCoreConstant.MP_LIVE_MODULE_CONTENT_BANNER -> {
                val listType = object : TypeToken<MPLineData<MPBannerData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            LivingCoreConstant.MP_LIVE_MODULE_NAVIGATION_CODE -> {
                val listType = object : TypeToken<MPLineData<MPNavigationData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            LivingCoreConstant.MP_LIVE_MODULE_CODE,
            LivingCoreConstant.MP_RECOMMEND_AUTHOR_LIST_CODE -> {
                val listType = object : TypeToken<MPLineData<MPLiveInfoData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            LivingCoreConstant.MP_RECOMMEND_AUTHOR_DATA_CODE -> {
                val listType = object : TypeToken<MPLineData<MPRecommendData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            LivingCoreConstant.MP_RECOMMEND_AUTHOR_DESC_CODE -> {
                val listType = object : TypeToken<MPLineData<MPRecommendDesc>>() {}.type
                return Gson().fromJson(json, listType)
            }
            else -> {
                return MPLineData()
            }
        }
    }
}