package com.yy.mobile.http

import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.yy.mobile.data.main.*
import java.lang.reflect.Type

/**
 * Created by PYF on 2019/3/2
 * 对lineData做的第二次尝试解析
 */

class HomepageDataJsonAdapter : JsonDeserializer<LineData<HomepageData>> {

    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): LineData<HomepageData> {
        val jsonObj = json?.asJsonObject
        when (jsonObj?.get("type")?.asString) {
            "1006" -> {
                val listType = object : TypeToken<LineData<BannerData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            "1011" -> {
                val listType = object : TypeToken<LineData<SubNavInfoData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            "1005", "2019" -> {
                val listType = object : TypeToken<LineData<LiveInfoData>>() {}.type
                return Gson().fromJson(json, listType)
            }
            else -> {
                return LineData()
            }
        }
    }
}