package com.yy.mobile.http

import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.yy.mobile.data.main.BaseNetData
import com.yy.mobile.data.main.HomepageData
import com.yy.mobile.data.main.LineData
import com.yy.mobile.data.main.LiveInfoData
import java.lang.reflect.Type

/**
 * Created by PYF on 2019/3/6
 */

class BaseNetDataErrorJsonAdapter : JsonDeserializer<BaseNetData> {

    override fun deserialize(
            json: JsonElement?,
            typeOfT: Type?,
            context: JsonDeserializationContext?
    ): BaseNetData {
        val jsonObj = json?.asJsonObject
        val data = jsonObj?.get("data")

        if (data?.isJsonArray == false) {
            val listType = object : TypeToken<LineData<LiveInfoData>>(){}.type
            val lineData: LineData<LiveInfoData> = Gson().fromJson(data, listType)
            val result = BaseNetData()
            result.data = mutableListOf(lineData) as MutableList<LineData<HomepageData>>
            return result
        }
        return Gson().fromJson(json, BaseNetData::class.java)
    }
}