package com.yy.mobile.data.nav;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

/**
 * Created by jianyanfu on 2016/1/11.
 * 二级导航数据实体
 */
public class SubLiveNavItem implements Parcelable {
    public int serv;
    public String name;
    public String biz;
    public int icon;
    public int selected;

    @Override
    public int describeContents() {
        return 0;
    }

    public SubLiveNavItem() {
    }

    public SubLiveNavItem(int serv, String biz) {
        this.serv = serv;
        this.biz = biz;
    }

    public SubLiveNavItem(int serv, String name, String biz, int icon, int selected) {
        this.serv = serv;
        this.name = name;
        this.biz = biz;
        this.icon = icon;
        this.selected = selected;
    }

    public SubLiveNavItem(Parcel source) {
        this();
        this.serv = source.readInt();
        this.name = source.readString();
        this.biz = source.readString();
        this.icon = source.readInt();
        this.selected = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(serv);
        dest.writeString(name);
        dest.writeString(biz);
        dest.writeInt(icon);
        dest.writeInt(selected);
    }

    public static final Creator<SubLiveNavItem> CREATOR = new Creator<SubLiveNavItem>() {
        @Override
        public SubLiveNavItem createFromParcel(Parcel source) {
            return new SubLiveNavItem(source);
        }

        @Override
        public SubLiveNavItem[] newArray(int size) {
            return new SubLiveNavItem[size];
        }
    };

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SubLiveNavItem)) {
            return false;
        }
        return TextUtils.equals(name, ((SubLiveNavItem) o).name)
                && TextUtils.equals(biz, ((SubLiveNavItem) o).biz);
    }

    @Override
    public String toString() {
        return "[serv = " + serv + ", name = " + name + ", biz = " + biz + "]";
    }

}
