package com.yy.mobile.data.nav

import android.os.Parcel
import android.os.Parcelable
import java.util.ArrayList

/**
 * @author zhengyongxin
 * @date 创建时间: 2018/6/21
 * @Description 描述
 */
data class LiveNavRowData(
    var code: Int = 0,
    var message: String = "",
    var data: MutableList<LiveNavInfo> = mutableListOf(),
    var extendInfo: NavExtendInfo = NavExtendInfo()
) : Parcelable {
    constructor(parcel: Parcel) : this(
        parcel.readInt(),
        parcel.readString(),
        parcel.createTypedArrayList(LiveNavInfo.CREATOR),
        parcel.readParcelable(NavExtendInfo::class.java.classLoader))

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(code)
        parcel.writeString(message)
        parcel.writeTypedList(data)
        parcel.writeParcelable(extendInfo, flags)
    }

    override fun describeContents(): Int {
        return 0
    }

    private val NAVIGATION_SUBSCRIBE_BIZ_CODE = "subscribe"

    companion object CREATOR : Parcelable.Creator<LiveNavRowData> {
        override fun createFromParcel(parcel: Parcel): LiveNavRowData {
            return LiveNavRowData(parcel)
        }

        override fun newArray(size: Int): Array<LiveNavRowData?> {
            return arrayOfNulls(size)
        }
    }

    fun getFilterData(): List<LiveNavInfo> {

        val liveNavInfos = ArrayList<LiveNavInfo>()
        for (liveNavInfo in data) {
            if (liveNavInfo.biz !== NAVIGATION_SUBSCRIBE_BIZ_CODE) {
                liveNavInfos.add(liveNavInfo)
            }
        }
        return liveNavInfos
    }

    override fun toString(): String {
        return "LiveNavRowData(code=$code, message='$message', data=$data, extendInfo=$extendInfo, " +
            "NAVIGATION_SUBSCRIBE_BIZ_CODE='$NAVIGATION_SUBSCRIBE_BIZ_CODE')"
    }
}

data class NavExtendInfo(
    var slideHide: Int = 0, // 0: 不隐藏； 1：隐藏
    var isTop: Int = 1, //是否支持置顶 1置顶 0不置顶
    var testId: String = "", //实验id
    var testGroup: Int = -1 //实验分组
) : Parcelable {
    constructor(parcel: Parcel) : this(
        parcel.readInt(),
        parcel.readInt(),
        parcel.readString(),
        parcel.readInt()
    )

    override fun writeToParcel(parcel: Parcel?, flags: Int) {
        parcel!!.writeInt(slideHide)
        parcel.writeInt(isTop)
        parcel.writeString(testId)
        parcel.writeInt(testGroup)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<NavExtendInfo> {
        override fun createFromParcel(parcel: Parcel): NavExtendInfo {
            return NavExtendInfo(parcel)
        }

        override fun newArray(size: Int): Array<NavExtendInfo?> {
            return arrayOfNulls(size)
        }
    }
}