package com.yy.mobile.data.nav;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jianyanfu on 2016/1/11.
 * 一级导航数据实体
 */
public class LiveNavInfo implements Parcelable {

    public String message;
    public int id;
    public int serv;
    public String name;
    public int icon;
    public String biz;
    public int selected; //服务器配置的默认启动tab
    public String pic;
    public String url = ""; //配置命令
    public int isShow = -1; //是否是外露tab 1外显 0不外显
    public int showSort = -1; //外露与非外露显示顺序不同，根据此排序外露tab，数值越大越靠后
    public List<SubLiveNavItem> navs = new ArrayList<>(); //其实根本就没解析到= =

    public LiveNavInfo() {
    }

    public LiveNavInfo(int serv, String biz) {
        this.serv = serv;
        this.biz = biz;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        LiveNavInfo that = (LiveNavInfo) o;

        return biz != null ? biz.equals(that.biz) : that.biz == null;
    }

    @Override
    public String toString() {
        return "[serv = " + serv + ", name = " + name + ", icon = " + icon + ", biz = " + biz + ", isShow =" + isShow + ", showSort=" + showSort + "]";
    }

    public List<SubLiveNavItem> getNavs() {
        return navs;
    }

    public String getBiz() {
        return biz;
    }

    public void setBiz(String biz) {
        this.biz = biz;
    }

    public int getServ() {
        return serv;
    }

    public void setServ(int serv) {
        this.serv = serv;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getIcon() {
        return icon;
    }

    public void setIcon(int icon) {
        this.icon = icon;
    }

    public int getSelected() {
        return selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public String getPic() {
        return pic;
    }

    public void setPic(String pic) {
        this.pic = pic;
    }

    public int getIsShow() {
        return isShow;
    }

    public void setIsShow(int isShow) {
        this.isShow = isShow;
    }

    public int getShowSort() {
        return showSort;
    }

    public void setShowSort(int showSort) {
        this.showSort = showSort;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.message);
        dest.writeInt(this.id);
        dest.writeInt(this.serv);
        dest.writeString(this.name);
        dest.writeInt(this.icon);
        dest.writeString(this.biz);
        dest.writeInt(this.selected);
        dest.writeString(this.pic);
        dest.writeString(this.url);
        dest.writeInt(this.isShow);
        dest.writeInt(this.showSort);
        dest.writeTypedList(this.navs);
    }

    protected LiveNavInfo(Parcel in) {
        this.message = in.readString();
        this.id = in.readInt();
        this.serv = in.readInt();
        this.name = in.readString();
        this.icon = in.readInt();
        this.biz = in.readString();
        this.selected = in.readInt();
        this.pic = in.readString();
        this.url = in.readString();
        this.isShow = in.readInt();
        this.showSort = in.readInt();
        this.navs = in.createTypedArrayList(SubLiveNavItem.CREATOR);
    }

    public static final Creator<LiveNavInfo> CREATOR = new Creator<LiveNavInfo>() {
        @Override
        public LiveNavInfo createFromParcel(Parcel source) {
            return new LiveNavInfo(source);
        }

        @Override
        public LiveNavInfo[] newArray(int size) {
            return new LiveNavInfo[size];
        }
    };
}
