package com.yy.mobile.data.meipai

import com.yy.mobile.data.base.HomepageData
import com.yy.mobile.data.base.LineData

/**
 * Created by liyang
 * on 2019/8/7
 */
data class MPLineData<T : HomepageData>(
    override var code: Int = 0,
    override var data: MutableList<T> = mutableListOf(),
    override var biz: String = "",
    override var id: Int = 0,// 模块ID
    override var isLastPage: Int = -1,// 是否最后一页：0-否，1-是
    override var limitNum: Int = 0,
    override var name: String = "",// 模块名称
    override var sort: Int = 0,
    override var status: Int = 0,
    override var type: Int = 0,// 模块类型：10000-banner，10001-导航栏，10002-直播数据
    var actionType: Int = 0,
    var head: Int = 0,// 是否显示头部（模块名称）：0-否，1-是
    var pageable: Int = -1,// 是否分页：0-否，1-是
    var subbiz: String = "",
    var url: String = "",// 更多的跳转链接：livemore：跳转二级页面查看所有内容，空字段串：不展示更多入口
    var page: Int = 1
) : LineData<T> {

    fun needLoadMore() = pageable == 1 && isLastPage == 0// 分页，且当前非最后一页
}