package com.yy.mobile.data.mainbean

import com.yy.mobile.constant.LivingCoreConstant
import com.yy.mobile.data.main.HomepageData
import com.yy.mobile.data.main.LineData
import com.yy.mobile.data.main.LiveInfoData
import com.yy.mobile.data.meipai.MPLiveInfoData

/**
 * Created by PYF on 2019/3/3
 */

class LineDataMultiType {
    var data: Any? = null

    var limitNum: Int = -1

    var biz: String = ""

    var code: Int = -1

    var sort: Int = -1

    var name: String = ""

    var id: Int = -1

    var status: Int = -1

    var type: Int = -1

    var isLastPage: Int = -1

    constructor(lineData: LineData<HomepageData>) {
        this.data = lineData.data
        this.limitNum = lineData.limitNum
        this.biz = lineData.biz
        this.code = lineData.code
        this.sort = lineData.sort
        this.name = lineData.name
        this.id = lineData.id
        this.status = lineData.status
        this.type = lineData.type
        this.isLastPage = lineData.isLastPage
    }

    constructor(lineData: LineData<HomepageData>, liveInfoData: LiveInfoData) {
        this.data = liveInfoData
        this.type = liveInfoData.type
        this.limitNum = lineData.limitNum
        this.biz = lineData.biz
        this.code = lineData.code
        this.sort = lineData.sort
        this.name = lineData.name
        this.id = lineData.id
        this.status = lineData.status
        this.isLastPage = lineData.isLastPage
    }

    constructor(lineData: com.yy.mobile.data.base.LineData<com.yy.mobile.data.base.HomepageData>) {
        this.data = lineData.data
        this.limitNum = lineData.limitNum
        this.biz = lineData.biz
        this.code = lineData.code
        this.sort = lineData.sort
        this.name = lineData.name
        this.id = lineData.id
        this.status = lineData.status
        this.type = if (lineData.type <= 0) 4 else lineData.type
        this.isLastPage = lineData.isLastPage
    }

    constructor(lineData: com.yy.mobile.data.base.LineData<com.yy.mobile.data.base.HomepageData>, liveInfoData: MPLiveInfoData) {
        this.data = liveInfoData
        this.type = lineData.type
        this.limitNum = lineData.limitNum
        this.biz = lineData.biz
        this.code = lineData.code
        this.sort = lineData.sort
        this.name = lineData.name
        this.id = lineData.id
        this.status = lineData.status
        this.isLastPage = lineData.isLastPage
    }

    constructor(type: Int) {
        this.type = type
    }

    constructor(type: Int, data: Any) {
        this.type = type
        this.data = data
    }

    companion object {
        fun convert(linedatas: List<LineData<HomepageData>>): MutableList<LineDataMultiType> {
            val list = mutableListOf<LineDataMultiType>()

            linedatas.forEachIndexed { index, lineData ->
                if (index % 2 > 0) {
                    //add margin
                    list.add(LineDataMultiType(LivingCoreConstant.Live_MODULE_MODULE_MARGIN_CODE))
                }
                if (lineData.type != LivingCoreConstant.Live_MODULE_CONTENT_CODE &&
                    lineData.type != LivingCoreConstant.MP_LIVE_MODULE_CODE) {
                    list.add(LineDataMultiType(lineData))
                } else {
                    //数据结构改成如果遇到直播模块，全部取出来变成一个一个的
                    lineData.data.forEach {
                        list.add(LineDataMultiType(lineData, it as LiveInfoData))
                    }
                }
            }
            return list
        }

        fun mpConvert(lineDataList: List<com.yy.mobile.data.base.LineData<com.yy.mobile.data.base.HomepageData>>): MutableList<LineDataMultiType> {
            val list = mutableListOf<LineDataMultiType>()

            lineDataList.forEachIndexed { index, lineData ->
                if (index % 2 > 0) {
                    //add margin
                    list.add(LineDataMultiType(LivingCoreConstant.Live_MODULE_MODULE_MARGIN_CODE))
                }
                if (lineData.type != LivingCoreConstant.Live_MODULE_CONTENT_CODE &&
                    lineData.type != LivingCoreConstant.MP_LIVE_MODULE_CODE) {
                    list.add(LineDataMultiType(lineData))
                } else {
                    //数据结构改成如果遇到直播模块，全部取出来变成一个一个的
                    lineData.data.forEach {
                        list.add(LineDataMultiType(lineData, it as MPLiveInfoData))
                    }
                }
            }
            return list
        }
    }

    override fun toString(): String {
        return "LineDataMultiType(data=$data, limitNum=$limitNum, biz='$biz', code=$code, " +
            "sort=$sort, name='$name', id=$id, status=$status, type=$type, isLastPage=$isLastPage)"
    }
}