package com.yy.mobile.data.main;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

/**
 * Class Name: ContentStyleInfo
 * Description:
 * Author: 郑永欣
 * Date: 2017/7/20
 * Modified History: 修改记录，格式(Name)  (Version)  (Date) (Reason & Contents)
 */

public class ContentStyleInfo implements Parcelable {
    @SerializedName("contentBgUrl")
    public String contentBgUrl; // 横滑模块背景图
    @SerializedName("bgColor")
    public String bgColor;  //标题和模块背景色
    @SerializedName("textColor")
    public String textColor; //标题和直播模块颜色

    public ContentStyleInfo(String contentBgUrl, String bgColor, String textColor) {
        this.contentBgUrl = contentBgUrl;
        this.bgColor = bgColor;
        this.textColor = textColor;
    }

    public ContentStyleInfo() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.contentBgUrl);
        dest.writeString(this.bgColor);
        dest.writeString(this.textColor);
    }

    protected ContentStyleInfo(Parcel in) {
        this.contentBgUrl = in.readString();
        this.bgColor = in.readString();
        this.textColor = in.readString();
    }

    public static final Creator<ContentStyleInfo> CREATOR = new Creator<ContentStyleInfo>() {
        @Override
        public ContentStyleInfo createFromParcel(Parcel source) {
            return new ContentStyleInfo(source);
        }

        @Override
        public ContentStyleInfo[] newArray(int size) {
            return new ContentStyleInfo[size];
        }
    };
}
