package com.yy.mobile.data.main

import com.yy.mobile.logs.MLog

/**
 * Created by PYF on 2019/3/2
 * Banner原始数据
 */

class BannerData : HomepageData() {

    var action: String = ""

    var actionType: Int = -1

    var createTime: String = ""

    var endTime: String = ""

    var id: Int = -1

    var image: String = ""

    var imageType: Int = -1

    var startTime: String = ""

    var title: String = ""

    var typeId: Int = -1

    var yyMobile: String = ""

    var bannerType: Int = -1

    var sort: Int = -1

    var sid: Long = -1L

    var ssid: Long = -1L

    companion object {
        const val LIVE_TYPE = 100
        const val WEB_TYPE = 200
    }

    init {
        parseSid()
    }

    fun getSuffix(w: Int, h: Int): String {
        return "?ips_thumbnail/4/0/w/$w/h/$h"
    }

    private fun parseSid() {
        if (action.isNotEmpty() && actionType == LIVE_TYPE) {
            val idInfos = action.split(",".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()
            if (idInfos.size >= 2) {
                try {
                    sid = Integer.parseInt(idInfos[0]).toLong()
                    ssid = Integer.parseInt(idInfos[0]).toLong()
                } catch (e: Exception) {
                    MLog.error("BannerData", "parseSid", e)
                }
            }
        }
    }

    override fun toString(): String {
        return "BannerData(action='$action', actionType=$actionType, createTime='$createTime', endTime='$endTime', id=$id, image='$image', imageType=$imageType, startTime='$startTime', title='$title', typeId=$typeId, yyMobile='$yyMobile', bannerType=$bannerType, sort=$sort)"
    }
}