package com.yy.mobile.constant

/**
 * Created by PYF on 2019/3/1
 */

object UrlSettings {

    private const val PRODUCT_DATA_DOMAIN = "w-mp.yy.com"
    private const val PRODUCT_IDX_DOMAIN = "w-mp.yy.com"

    private const val TEST_DATA_DOMAIN = "wtest-mp.yy.com"
    private const val TEST_IDX_DOMAIN = "wtest-mp.yy.com"

    var HOST_DATA_3G_YY_COM = "http://$PRODUCT_DATA_DOMAIN"
    var PLUGINS_CONFIG_URL = "$HOST_DATA_3G_YY_COM/link/plugins"

    //5.0新首页
    var LIVING_NAV_INFO = "http://$PRODUCT_IDX_DOMAIN/navs/" //主页导航栏
    var LIVING_HOME_UI_CONTROLLER = "http://$PRODUCT_DATA_DOMAIN/switch/info?typeKey=idx" //主页控制开关
    var LOLLIPOP_HOME_PAGE = "http://$PRODUCT_IDX_DOMAIN"   //大首页
    var LOLLIPOP_MOBILE_LIVE = "http://$PRODUCT_DATA_DOMAIN" //现场
    var LOLLIPOP_LIVING = "http://d.3g.yy.com"        //秀场
    //    public static String LOLLIPOP_LIVING_PREVIEW = "http://" + PRODUCT_IDX_DOMAIN + "/preview/infoList";  //预告
    var LIVING_HOME_PREVIEW_V2 = "http://$PRODUCT_IDX_DOMAIN/previewV2/infoList"  //预告V2
    var LIVING_CHANNEL_PREVIEW = "http://$PRODUCT_DATA_DOMAIN/mob/preview/v2/"  //直播间预告
    var LOLLIPOP_LIVING_TOPIC_LIST = "http://$PRODUCT_IDX_DOMAIN/topic/infoList" //专题
    var LOLLIPOP_LIVING_TOPIC_DETAIL = "http://$PRODUCT_DATA_DOMAIN/mob/v2/topic/data" //专题详情页基础地址，后加id
    var LOLLIPOP_LIVING_TOPIC_SHARE = "http://w.3g.yy.com/s/topicv2/share_" //专题分享基础地址
    var LOLLIPOP_LIVING_BIZ_JSON = "http://$PRODUCT_IDX_DOMAIN/nav/biz"   //biz对应标签 匹配地址
    var LOLLIPOP_LIVING_AREA_JSON = "http://res.3g.yy.com/config/m/android/area.json"   //省市信息
    var LOLLIPOP_LIVING_IDX_CONFIG = "http://res.3g.yy.com/config/m/android/idx.json"   //首页配置地址
    var CHANNEL_LIVING_HOST_INFO_URL = "http://$PRODUCT_DATA_DOMAIN/channel/v2/liveAnchor?"
    var LIVE_OPERATIONAL_CONFIGURATION = "http://$PRODUCT_IDX_DOMAIN/coping/extendedIcon"   //首页运营位
    var IM_OFFICIAL_ACCOUNT_URL = "http://aq.yy.com/p/school/officialList.do" //官方账号列表请求地址
    var UDB_PHONE_BIND_STATE_URL = "http://order.yy.com/order/mobile/getAuthApplyCapable.action" //请求手机绑定状态
    var GAME_PLAY_POLY = "http://$PRODUCT_DATA_DOMAIN/play/assemble/"   //玩法聚合页
    var PAY_ONE_AUTHOR_INFO_PAGE = "https://web.yy.com/livePlay/anchor-info.html" //陪玩主播个人信息页
    var TASK_CENTER_CHECKIN = "http://web.yy.com/sy_signin_reward/index.html" //签到
    var RECOMMEND_AUTHOR_POPUP_DIALOG = "http://$PRODUCT_DATA_DOMAIN/nav/recomAnchorPopup/idx/"// 推荐主播弹窗

    fun init() {
//        if (uriSetting === EnvUriSetting.Dev) { //开发环境地址
//            initDevUri()
//        } else if (uriSetting === EnvUriSetting.Product) { //生产环境地址
//            initProductUri()
//        } else if (uriSetting === EnvUriSetting.Test) { //测试环境地址
//            initTestUri()
//        }
        //暂时默认测试环境
        initTestUri()
        PLUGINS_CONFIG_URL = HOST_DATA_3G_YY_COM + "/link/plugins"
    }

    init {
        //暂时默认测试环境
        initTestUri()
    }

    fun initDevUri() {
        HOST_DATA_3G_YY_COM = "http://$TEST_DATA_DOMAIN"
        LIVING_NAV_INFO = "http://$TEST_IDX_DOMAIN/navs" //主页导航栏
        LIVING_HOME_UI_CONTROLLER = "http://$TEST_DATA_DOMAIN/switch/info?typeKey=idx" //主页ui样式控制开关
        LOLLIPOP_HOME_PAGE = "http://$TEST_IDX_DOMAIN"   //大首页
        LOLLIPOP_MOBILE_LIVE = "http://$TEST_DATA_DOMAIN" //现场
        LOLLIPOP_LIVING = "http://ddev.3g.yy.com"        //秀场
        //        LOLLIPOP_LIVING_PREVIEW = "http://" + TEST_IDX_DOMAIN + "/preview/infoList";  //预告
        LIVING_HOME_PREVIEW_V2 = "http://$TEST_IDX_DOMAIN/previewV2/infoList"  //预告V2
        LIVING_CHANNEL_PREVIEW = "http://$TEST_DATA_DOMAIN/mob/preview/v2/"  //直播间预告
        LOLLIPOP_LIVING_TOPIC_LIST = "http://$TEST_IDX_DOMAIN/topic/infoList" //专题
        LOLLIPOP_LIVING_TOPIC_DETAIL = "http://$TEST_DATA_DOMAIN/mob/v2/topic/data" //专题详情页基础地址，后加id
        LOLLIPOP_LIVING_TOPIC_SHARE = "http://wdev.3g.yy.com/s/topicv2/share_" //专题分享基础地址
        LOLLIPOP_LIVING_BIZ_JSON = "http://$TEST_IDX_DOMAIN/nav/biz"
        LOLLIPOP_LIVING_AREA_JSON = "http://resdev.3g.yy.com/config/m/android/area.json"   //省市信息
        LOLLIPOP_LIVING_IDX_CONFIG = "http://resdev.3g.yy.com/config/m/android/idx.json"   //首页配置地址
        CHANNEL_LIVING_HOST_INFO_URL = "http://$TEST_DATA_DOMAIN/channel/v2/liveAnchor?" //首页直播条主播信息url
        LIVE_OPERATIONAL_CONFIGURATION = "http://$TEST_IDX_DOMAIN/coping/extendedIcon" //首页运营位
        GAME_PLAY_POLY = "http://$TEST_DATA_DOMAIN/play/assemble/"   //玩法聚合页
        PAY_ONE_AUTHOR_INFO_PAGE = "https://webdev.yy.com/livePlay/anchor-info.html" //陪玩主播个人信息页
        TASK_CENTER_CHECKIN = "http://webtest.yy.com/sy_signin_reward/index.html"
    }

    fun initProductUri() {
        HOST_DATA_3G_YY_COM = "http://$PRODUCT_DATA_DOMAIN"
        LIVING_NAV_INFO = "http://$PRODUCT_IDX_DOMAIN/navs" //主页导航栏
        LIVING_HOME_UI_CONTROLLER = "http://$PRODUCT_DATA_DOMAIN/switch/info?typeKey=idx" //主页ui样式控制开关
        LOLLIPOP_HOME_PAGE = "http://$PRODUCT_IDX_DOMAIN"   //大首页
        LOLLIPOP_MOBILE_LIVE = "http://$PRODUCT_DATA_DOMAIN" //现场
        LOLLIPOP_LIVING = "http://d.3g.yy.com"        //秀场
        //        LOLLIPOP_LIVING_PREVIEW = "http://" + PRODUCT_IDX_DOMAIN + "/preview/infoList";  //预告
        LIVING_HOME_PREVIEW_V2 = "http://$PRODUCT_IDX_DOMAIN/previewV2/infoList"  //预告V2
        LIVING_CHANNEL_PREVIEW = "http://$PRODUCT_DATA_DOMAIN/mob/preview/v2/"  //直播间预告
        LOLLIPOP_LIVING_TOPIC_LIST = "http://$PRODUCT_IDX_DOMAIN/topic/infoList" //专题
        LOLLIPOP_LIVING_TOPIC_DETAIL = "http://$PRODUCT_DATA_DOMAIN/mob/v2/topic/data" //专题详情页基础地址，后加id
        LOLLIPOP_LIVING_TOPIC_SHARE = "http://w.3g.yy.com/s/topicv2/share_" //专题分享基础地址
        LOLLIPOP_LIVING_BIZ_JSON = "http://$PRODUCT_IDX_DOMAIN/nav/biz"
        LOLLIPOP_LIVING_AREA_JSON = "http://res.3g.yy.com/config/m/android/area.json"   //省市信息
        LOLLIPOP_LIVING_IDX_CONFIG = "http://res.3g.yy.com/config/m/android/idx.json"   //首页配置地址
        CHANNEL_LIVING_HOST_INFO_URL = "http://$PRODUCT_DATA_DOMAIN/channel/v2/liveAnchor?" //首页直播条主播信息url
        LIVE_OPERATIONAL_CONFIGURATION = "http://$PRODUCT_IDX_DOMAIN/coping/extendedIcon" //首页运营位
        GAME_PLAY_POLY = "http://$PRODUCT_DATA_DOMAIN/play/assemble/"   //玩法聚合页
        PAY_ONE_AUTHOR_INFO_PAGE = "https://web.yy.com/livePlay/anchor-info.html" //陪玩主播个人信息页
        TASK_CENTER_CHECKIN = "http://web.yy.com/sy_signin_reward/index.html"
    }

    private fun initTestUri() {
        LIVING_NAV_INFO = "http://$TEST_IDX_DOMAIN/navs" //主页导航栏
        LIVING_HOME_UI_CONTROLLER = "http://$TEST_DATA_DOMAIN/switch/info?typeKey=idx" //主页ui样式控制开关
        HOST_DATA_3G_YY_COM = "http://$TEST_DATA_DOMAIN"
        LOLLIPOP_HOME_PAGE = "http://$TEST_IDX_DOMAIN"   //大首页
        LOLLIPOP_MOBILE_LIVE = "http://$TEST_DATA_DOMAIN" //现场
        LOLLIPOP_LIVING = "http://dtest.3g.yy.com"        //秀场
        //        LOLLIPOP_LIVING_PREVIEW = "http://" + TEST_IDX_DOMAIN + "/preview/infoList";  //预告
        LIVING_HOME_PREVIEW_V2 = "http://$TEST_IDX_DOMAIN/previewV2/infoList"  //预告V2
        LIVING_CHANNEL_PREVIEW = "http://$TEST_DATA_DOMAIN/mob/preview/v2/"  //直播间预告
        LOLLIPOP_LIVING_TOPIC_LIST = "http://$TEST_IDX_DOMAIN/topic/infoList" //专题
        LOLLIPOP_LIVING_TOPIC_DETAIL = "http://$TEST_DATA_DOMAIN/mob/v2/topic/data" //专题详情页基础地址，后加id
        LOLLIPOP_LIVING_TOPIC_SHARE = "http://wtest.3g.yy.com/s/topicv2/share_" //专题分享基础地址
        LOLLIPOP_LIVING_BIZ_JSON = "http://$TEST_IDX_DOMAIN/nav/biz"
        LOLLIPOP_LIVING_AREA_JSON = "http://restest.3g.yy.com/config/m/android/area.json"   //省市信息
        LOLLIPOP_LIVING_IDX_CONFIG = "http://restest.3g.yy.com/config/m/android/idx.json"   //首页配置地址
        CHANNEL_LIVING_HOST_INFO_URL = "http://$TEST_DATA_DOMAIN/channel/v2/liveAnchor?" //首页直播条主播信息url
        LIVE_OPERATIONAL_CONFIGURATION = "http://$TEST_IDX_DOMAIN/coping/extendedIcon" //首页运营位
        GAME_PLAY_POLY = "http://$TEST_DATA_DOMAIN/play/assemble/"   //玩法聚合页
        PAY_ONE_AUTHOR_INFO_PAGE = "https://webtest.yy.com/livePlay/anchor-info.html" //陪玩主播个人信息页
        TASK_CENTER_CHECKIN = "http://webtest.yy.com/sy_signin_reward/index.html"


        PLUGINS_CONFIG_URL = HOST_DATA_3G_YY_COM + "/link/plugins"
        RECOMMEND_AUTHOR_POPUP_DIALOG = "http://$TEST_DATA_DOMAIN/nav/recomAnchorPopup/idx/"// 推荐主播弹窗
    }
}