package com.yy.mobile.constant

import com.yy.mobile.data.base.HomepageData
import com.yy.mobile.data.base.LineData
import com.yy.mobile.data.meipai.MPLineData
import com.yy.mobile.data.nav.LiveNavInfo
import com.yy.mobile.data.nav.SubLiveNavItem

/**
 * Created by PYF on 2019/3/1
 * copy，感觉要GG
 */
object LivingCoreConstant {

    /**
     * 首页导航请求URL拼接
     */
    fun getServerUrl(navInfo: LiveNavInfo?, subNavInfo: SubLiveNavItem?): String {
        if (navInfo == null || subNavInfo == null) {
            return "http://wtest-mp.yy.com/nav/yylive/idx/"
        }
        return "${getServ(subNavInfo.serv)}/nav/${navInfo.biz}/${subNavInfo.biz}/"
    }

    /**
     * 首页更多分页请求URL拼接
     */
    fun getServerUrl(navInfo: LiveNavInfo?, subNavInfo: SubLiveNavItem?, moduleId: Int, page: Int): String {
        if (navInfo == null || subNavInfo == null) {
            return ""
        }
        return "${getServ(subNavInfo.serv)}/nav/${navInfo.biz}/${subNavInfo.biz}/$moduleId/"
    }

    fun getMoreServerUrl(lineData: MPLineData<HomepageData>): String {
        if (lineData.biz.isEmpty() || lineData.subbiz.isEmpty()) {
            return "http://wtest-mp.yy.com/nav/yylive/idx/103149/"
        }
        return "http://wtest-mp.yy.com/nav/${lineData.biz}/${lineData.subbiz}/${lineData.id}/"
    }

    /**
     * 首页标签页分页请求URL拼接
     */
//    fun getLabelServUrl(label: String, page: Int): String {
//        return UrlSettings.LOLLIPOP_MOBILE_LIVE + "/" + EnvUriSetting.getUriAppType() + "/tag/" + label + "/" + page
//    }

    /**
     * 首页请求获取serv
     */
    private fun getServ(serv: Int): String {
        return when (serv) {
            1 -> UrlSettings.LOLLIPOP_HOME_PAGE
            2 -> UrlSettings.LOLLIPOP_MOBILE_LIVE
            3, 4 -> UrlSettings.LOLLIPOP_LIVING
            else -> UrlSettings.LOLLIPOP_MOBILE_LIVE
        }
    }

    /**
     * 判断Type是否为已知
     */
    fun isLegalType(type: Int): Boolean {
        return when (type) {
            LIVING_TYPE_SHOW_LIVE,
            LIVING_TYPE_MOBILE_LIVE,
            LIVING_TYPE_MOBILE_REPLAY,
            LIVING_TYPE_GAME_LIVE,
            LIVING_TYPE_COLUMN_MODULE,
            LIVING_TYPE_TOPIC,
            LIVING_TYPE_TAGS_COMBINE_MODULE -> true
            else -> false
        }
    }

    /**
     * 判断Type是否为直播
     */
    fun isLiveType(type: Int): Boolean {
        return when (type) {
            LIVING_TYPE_SHOW_LIVE,
            LIVING_TYPE_MOBILE_LIVE,
            LIVING_TYPE_GAME_LIVE -> true
            else -> false
        }
    }

    /**
     * 数量：超过1万时，用‘万’表示，小数点后显示1位
     *
     * @param count 人数
     * @return 人数对应需要显示的字符串
     */
    fun formatCount(count: Long) = formatCountNoUnit(count) + "万"

    /**
     * 数量：超过1万时，无单位，小数点后显示1位
     *
     * @param count 人数
     * @return 人数对应需要显示的字符串
     */
    fun formatCountNoUnit(count: Long) =
        if (count < 10000L) count.toString() else String.format("%.1f", count / 10000.0)

    /**
     * 现场直播
     */
    const val LIVING_TYPE_MOBILE_LIVE = 1

    /**
     * 现场录播
     */
    const val LIVING_TYPE_MOBILE_REPLAY = 2

    /**
     * 专题
     */
    const val LIVING_TYPE_TOPIC = 3

    /**
     * 秀场直播
     */
    const val LIVING_TYPE_SHOW_LIVE = 4

    /**
     * 电竞直播
     */
    const val LIVING_TYPE_GAME_LIVE = 8

    /**
     * 通栏banner
     */
    const val LIVING_TYPE_COLUMN_MODULE = 9

    /**
     * 文字banner
     */
    val LIVING_TYPE_TEXT_BANNER_MODULE = 19

    /**
     * 标签聚合（4合1）
     */
    val LIVING_TYPE_TAGS_COMBINE_MODULE = 21

    /////////////////////模块ID//////////////////////
    /**
     * 普通Banner
     * a
     */
    const val Live_MODULE_BANNER_CODE = 1006

    /**
     * 大顶Banner
     */
    const val Live_MODULE_BIG_BANNER_CODE = 1001

    /**
     * 标签模块
     */
    const val Live_MODULE_TAG_CODE = 1011

    /**
     * 模块间间隔
     */
    const val Live_MODULE_MODULE_MARGIN_CODE = 108

    /**
     * 尾页底部显示没有更多
     */
    const val Live_MODULE_NO_MORE_CODE = 109

    /**
     * 普通内容模块
     * a
     */
    const val Live_MODULE_CONTENT_CODE = 1005

    /**
     * 明星现场
     */
    const val Live_MODULE_STAR_CONTENT_CODE = 1007

    /**
     * 品牌专区
     */
    const val Live_MODULE_BRAND_CONTENT_CODE = 1008

    /**
     * 关注tab的正在直播
     */
    const val Live_MODULE_FOLLOW_LIVING = 2019
    const val Live_MODULE_FOLLOW_LIVING_TYPE = 20251

    /**
     * 口味推荐类型-直播
     */
    const val Live_MODULE_TASTE_LIVE = 2026

    /**
     * 拼接导航栏地址 首页固定字段
     */
    const val LIVE_URL_FIXED_IDX_STR = "idx"  //拼接导航栏地址 首页固定字段

    /**
     * title
     */
    const val Live_MODULE_COMMON_TITLE_CODE = 101

    const val BANNER_LIVE_TYPE = 100
    const val BANNER_WEB_TYPE = 200

    const val CMCC = "CMCC"
    const val CTL = "CTL"
    const val UNICOM = "UNICOM"
    const val UNKNOWN = "Unknown"

    /**
     * 美拍引入Banner的Type
     *
     */
    const val MP_LIVE_MODULE_BANNER_CODE = 10000

    /**
     * 美拍引入导航栏的Type
     *
     */
    const val MP_LIVE_MODULE_NAVIGATION_CODE = 10001

    /**
     * 美拍引入直播豆腐块的Type
     *
     */
    const val MP_LIVE_MODULE_CODE = 10002

    /**
     * 美拍推荐主播列表配置
     */
    const val MP_RECOMMEND_AUTHOR_LIST_CODE = 10007

    /**
     * 美拍推荐主播数据配置
     */
    const val MP_RECOMMEND_AUTHOR_DATA_CODE = 10008

    /**
     * 美拍推荐主播推荐语配置
     */
    const val MP_RECOMMEND_AUTHOR_DESC_CODE = 10009

    /**
     * 内容BannerType
     */
    const val MP_LIVE_MODULE_CONTENT_BANNER = 10010
}