package com.yy.mobile.api

import com.yy.mobile.logs.MLog

/**
 * 这么写真的好么
 */
object HPBasicActionHandler {

    const val TAG = "HPBasicActionHandler"

    private var sListener: HPBasicActionCallback? = null

    fun setListener(listener: HPBasicActionCallback) {
        this.sListener = listener
    }

    fun handleEnterLiveRoom(sid: Long, ssid: Long) {
        MLog.info(TAG, "handleEnterLiveRoom: params: sid = $sid, ssid = $ssid")
        if (sid < 0 || ssid < 0) {
            return
        }
        sListener?.enterLiveRoom(sid, ssid)
    }

    fun handleEnterH5(url: String) {
        MLog.info(TAG, "handleEnterH5: url = $url")
        sListener?.enterH5page(url)
    }

    fun handleEnterFollow() {
        MLog.info(TAG, "handleEnterFollow")
        sListener?.enterPersonalCenter()
    }

    fun handleEnterSetting() {
        MLog.info(TAG, "handleEnterSetting")
        sListener?.enterSettingPage()
    }
}