/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.analytics.filter;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.analytics.filter.c;
import com.umeng.commonsdk.debug.UMRTLog;
import com.umeng.commonsdk.framework.UMEnvelopeBuild;
import com.umeng.commonsdk.internal.crash.UMCrashManager;
import com.umeng.commonsdk.statistics.common.HelperUtils;
import com.umeng.commonsdk.statistics.idtracking.ImprintHandler;
import com.umeng.commonsdk.utils.FileLockCallback;
import com.umeng.commonsdk.utils.FileLockUtil;
import com.umeng.commonsdk.utils.UMUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class EventList
extends c
implements FileLockCallback {
    protected String mEventListName;
    protected String mEventListKey;
    protected String mEventList;
    private Context mAppContext;
    protected String mEventListVersionKey;
    private static final int SAVE_LIST_DATA = 0;
    private static final int LOAD_LIST_DATA = 1;
    private static final int DELETE_LIST_DATA = 2;
    private FileLockUtil mFileLock;

    public EventList(String string, String string2) {
        this.mEventListName = string;
        this.mEventListKey = string;
        this.mEventListVersionKey = string2;
        this.mFileLock = new FileLockUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        EventList eventList = this;
        synchronized (eventList) {
            return this.mEventList != null;
            {
            }
        }
    }

    public void setMD5ClearFlag(boolean bl2) {
    }

    protected void eventListChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadEventListFromFile(Context context, File file) {
        if (file.exists() && TextUtils.isEmpty((CharSequence)this.mEventList)) {
            BufferedReader bufferedReader = null;
            try {
                FileReader fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                StringBuilder stringBuilder = new StringBuilder();
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                String string2 = stringBuilder.toString();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    String string3 = HelperUtils.getMD5(string2);
                    String string4 = UMEnvelopeBuild.imprintProperty(context, this.mEventListVersionKey, "");
                    this.mEventList = string2;
                    this.eventListChange();
                    UMRTLog.i("MobclickRT", "--->>> loadEventListFromFile: mEventList = " + this.mEventList);
                    if (UMUtils.isMainProgress(context)) {
                        if (string3.equalsIgnoreCase(string4)) {
                            this.mEventList = string2;
                            this.setMD5ClearFlag(false);
                            boolean bl2 = true;
                            return bl2;
                        }
                        this.setMD5ClearFlag(true);
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (string3.equalsIgnoreCase(string4)) {
                        this.mEventList = string2;
                        this.eventListChange();
                        boolean bl4 = true;
                        return bl4;
                    }
                    boolean bl5 = false;
                    return bl5;
                }
            }
            catch (Throwable throwable) {
                UMCrashManager.reportCrash(context, throwable);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        UMCrashManager.reportCrash(context, throwable);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataFile(File file) {
        if (this.mAppContext != null) {
            FileLockUtil fileLockUtil = this.mFileLock;
            synchronized (fileLockUtil) {
                if (file.exists()) {
                    file.delete();
                }
            }
        }
    }

    private void saveEventListToFile(Context context, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.mEventList.getBytes());
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            UMCrashManager.reportCrash(context, throwable);
        }
    }

    public void register(Context context) {
        if (this.mAppContext == null) {
            this.mAppContext = context.getApplicationContext();
        }
        File file = new File(this.mAppContext.getFilesDir(), this.mEventListName);
        String string = UMEnvelopeBuild.imprintProperty(this.mAppContext, this.mEventListVersionKey, "");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (file.exists()) {
                this.mFileLock.doFileOperateion(file, (FileLockCallback)this, 1);
            } else {
                this.setMD5ClearFlag(true);
            }
        }
        if (UMUtils.isMainProgress(this.mAppContext)) {
            ImprintHandler.getImprintService(this.mAppContext).registPreProcessCallback(this.mEventListKey, this);
            ImprintHandler.getImprintService(this.mAppContext).registImprintCallback(this.mEventListVersionKey, this);
        }
    }

    public boolean matchHit(String string) {
        return false;
    }

    @Override
    public void onImprintValueChanged(String string, String string2) {
        File file;
        if ("ekv_bl_ver".equals(string) && string2 == null) {
            UMRTLog.i("MobclickRT", "--->>> disable black list for ekv.");
            file = new File(this.mAppContext.getFilesDir(), this.mEventListName);
            this.mFileLock.doFileOperateion(file, (FileLockCallback)this, 2);
        }
        if ("ekv_wl_ver".equals(string) && string2 == null) {
            UMRTLog.i("MobclickRT", "--->>> disable white list for ekv.");
            file = new File(this.mAppContext.getFilesDir(), this.mEventListName);
            this.mFileLock.doFileOperateion(file, (FileLockCallback)this, 2);
        }
    }

    @Override
    public boolean onPreProcessImprintKey(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            int n2 = string2.length();
            UMRTLog.i("MobclickRT", "--->>> onPreProcessImprintKey: key = " + string + "; len of value=" + n2);
            UMRTLog.i("MobclickRT", "--->>> onPreProcessImprintKey: value = " + string2);
            this.mEventList = string2;
            this.eventListChange();
            File file = new File(this.mAppContext.getFilesDir(), this.mEventListName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException2) {
                        UMCrashManager.reportCrash(this.mAppContext, iOException2);
                    }
                }
            }
            this.mFileLock.doFileOperateion(file, (FileLockCallback)this, 0);
            this.setMD5ClearFlag(false);
        }
        return true;
    }

    public String toString() {
        if (!TextUtils.isEmpty((CharSequence)this.mEventListName) && !TextUtils.isEmpty((CharSequence)this.mEventListKey)) {
            StringBuilder stringBuilder = new StringBuilder("[");
            stringBuilder.append("EventListName:" + this.mEventListName + ",");
            stringBuilder.append("listKey:" + this.mEventListKey + ",");
            if (!TextUtils.isEmpty((CharSequence)this.mEventList)) {
                stringBuilder.append("listKeyValue:" + this.mEventList + "]");
            } else {
                stringBuilder.append("listKeyValue:empty,");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mEventListVersionKey)) {
                stringBuilder.append("listKeyVer:" + this.mEventListVersionKey + "]");
            } else {
                stringBuilder.append("listKeyVer:empty]");
            }
            return stringBuilder.toString();
        }
        return "Uninitialized EventList.";
    }

    @Override
    public boolean onFileLock(String string) {
        return false;
    }

    @Override
    public boolean onFileLock(String string, Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onFileLock(File file, int n2) {
        if (n2 == 0) {
            EventList eventList = this;
            synchronized (eventList) {
                this.saveEventListToFile(this.mAppContext, file);
            }
        }
        if (n2 == 1) {
            EventList eventList = this;
            synchronized (eventList) {
                if (this.loadEventListFromFile(this.mAppContext, file)) {
                    UMRTLog.i("MobclickRT", "--->>> find event list data file, load it.");
                } else {
                    UMRTLog.i("MobclickRT", "--->>> can't find event list file.");
                }
            }
        }
        if (n2 == 2) {
            EventList eventList = this;
            synchronized (eventList) {
                this.mEventList = null;
                this.deleteDataFile(file);
            }
        }
        return true;
    }
}

