/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.vungle;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.vungle.VungleErrorUtil;
import com.tradplus.ads.vungle.VungleInitManager;
import com.tradplus.ads.vungle.VungleInterstitialCallbackRouter;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleTradPlusBanner
extends TPBannerAdapter {
    private String placementId;
    private String payload;
    private String appId;
    private RelativeLayout container;
    private boolean destroyed;
    private String mAdSize;
    private VungleBanner mVungleBanner;
    private TPBannerAdImpl mTpBannerAd;
    private BannerAdConfig bannerAdConfig;
    private RelativeLayout mRelativeLayout;
    private VungleInterstitialCallbackRouter mICbR;
    private static final String TAG = "VungleBanner";
    private Map<String, Object> localExtras;
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback(){

        public void onAdLoad(String placementReferenceID) {
            VungleTradPlusBanner.this.VungleBannerPlayAd();
        }

        public void onError(String placementReferenceID, VungleException throwable) {
            Log.i((String)VungleTradPlusBanner.TAG, (String)("onError ,placementReferenceID : " + placementReferenceID + " , errormessage :" + throwable.getLocalizedMessage()));
            if (VungleTradPlusBanner.this.mLoadAdapterListener != null) {
                VungleTradPlusBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(VungleErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", (Throwable)throwable));
            }
        }
    };
    private final PlayAdCallback vunglebannerPlayAdCallback = new PlayAdCallback(){

        public void creativeId(String s) {
        }

        public void onAdStart(String s) {
            Log.i((String)VungleTradPlusBanner.TAG, (String)("Vungle Banner onAdStart ,placementReferenceID : " + s));
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (VungleTradPlusBanner.this.mVungleBanner == null) {
                        return;
                    }
                    VungleTradPlusBanner.this.mVungleBanner.setVisibility(8);
                    VungleTradPlusBanner.this.mVungleBanner.setAdVisibility(false);
                    VungleTradPlusBanner.this.mVungleBanner.setVisibility(0);
                    VungleTradPlusBanner.this.mVungleBanner.setAdVisibility(true);
                }
            }, 1000L);
            if (VungleTradPlusBanner.this.mTpBannerAd != null) {
                VungleTradPlusBanner.this.mTpBannerAd.adShown();
            }
        }

        public void onAdEnd(String id, boolean completed, boolean isCTAClicked) {
        }

        public void onAdEnd(String id) {
        }

        public void onAdClick(String id) {
            Log.d((String)"TradPlus", (String)("Vungle Banner isCTAClicked ,placementReferenceID : " + id));
            if (VungleTradPlusBanner.this.mTpBannerAd != null) {
                VungleTradPlusBanner.this.mTpBannerAd.adClicked();
            }
        }

        public void onAdRewarded(String id) {
        }

        public void onAdLeftApplication(String id) {
            Log.i((String)VungleTradPlusBanner.TAG, (String)("Vungle Banner onAdLeftApplication ,placementReferenceID : " + id));
        }

        public void onError(String s, VungleException e) {
        }

        public void onAdViewed(String id) {
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.localExtras = localExtras;
        if (this.extrasAreValid(serverExtras)) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            this.payload = serverExtras.get("Bidding-Payload");
            this.mAdSize = serverExtras.get("ad_size" + this.placementId) != null ? ("0".equals(serverExtras.get("ad_size" + this.placementId)) ? "0" : serverExtras.get("ad_size" + this.placementId)) : "1";
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        Log.i((String)TAG, (String)("BannerSize: " + this.mAdSize + ". '1' means ad size will be 320 * 50 , '2' means ad size will be 300*50 , '3' means ad size will be 728* 90 only for tablets,'0' means ad size will be 300 * 250"));
        this.mICbR = VungleInterstitialCallbackRouter.getInstance();
        VungleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Banners.loadBanner((String)VungleTradPlusBanner.this.placementId, (String)VungleTradPlusBanner.this.isEmptyPayLoad(), (BannerAdConfig)VungleTradPlusBanner.this.getBannerAdConfig("0".equals(VungleTradPlusBanner.this.mAdSize)), (LoadAdCallback)VungleTradPlusBanner.this.vungleLoadAdCallback);
            }

            public void onFailed(String code, String msg) {
                if (VungleTradPlusBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    VungleTradPlusBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private String isEmptyPayLoad() {
        return TextUtils.isEmpty((CharSequence)this.payload) ? null : this.payload;
    }

    private BannerAdConfig getBannerAdConfig(boolean isMrec) {
        if (this.bannerAdConfig == null) {
            this.bannerAdConfig = new BannerAdConfig();
        }
        this.bannerAdConfig.setAdSize(isMrec ? AdConfig.AdSize.VUNGLE_MREC : this.calculateAdSize(this.mAdSize));
        this.bannerAdConfig.setMuted(true);
        return this.bannerAdConfig;
    }

    public void clean() {
        if (this.mVungleBanner != null) {
            Log.i((String)TAG, (String)"clean: ");
            this.destroyed = true;
            this.mVungleBanner.destroyAd();
            this.mVungleBanner = null;
        }
    }

    private void VungleBannerPlayAd() {
        if (Banners.canPlayAd((String)this.placementId, (String)this.isEmptyPayLoad(), (AdConfig.AdSize)this.calculateAdSize(this.mAdSize))) {
            this.mVungleBanner = Banners.getBanner((String)this.placementId, (String)this.isEmptyPayLoad(), (BannerAdConfig)this.getBannerAdConfig("0".equals(this.mAdSize)), (PlayAdCallback)this.vunglebannerPlayAdCallback);
            if (this.mVungleBanner == null) {
                Log.i((String)TAG, (String)"onAdLoad, but Banners.getBanner return null");
                if (this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network failed to provide an ad.");
                    tpError.setErrorMessage("onAdLoad, but Banners.getBanner return null");
                    this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Didn't find valid adv.Show Failed"));
                }
                return;
            }
            if ("0".equals(this.mAdSize)) {
                this.setDefaultAdViewSize(320, 250);
            }
            this.mTpBannerAd = new TPBannerAdImpl(null, (View)this.mVungleBanner);
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mTpBannerAd);
            }
            return;
        }
        if (this.mLoadAdapterListener != null) {
            Log.i((String)TAG, (String)"onAdLoad, but Banners can't PlayAd ");
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage("onAdLoad\uff0cbut Banners can't PlayAd");
            this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("7");
    }

    public String getNetworkVersion() {
        return "6.11.0";
    }

    private AdConfig.AdSize calculateAdSize(String adSize) {
        Log.i((String)TAG, (String)("calculateAdSize: " + adSize));
        if (adSize.equals("1")) {
            return AdConfig.AdSize.BANNER;
        }
        if (adSize.equals("2")) {
            return AdConfig.AdSize.BANNER_SHORT;
        }
        if (adSize.equals("3")) {
            return AdConfig.AdSize.BANNER_LEADERBOARD;
        }
        if (adSize.equals("0")) {
            return AdConfig.AdSize.VUNGLE_MREC;
        }
        return AdConfig.AdSize.BANNER;
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams) {
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return "";
        }
        this.appId = tpParams.get("appId");
        this.placementId = tpParams.get("placementId");
        if (GlobalTradPlus.getInstance().getContext() != null && !TextUtils.isEmpty((CharSequence)this.appId)) {
            VungleInitManager.getInstance().initSDK(context, this.localExtras, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                }

                public void onFailed(String code, String msg) {
                }
            });
            return Vungle.getAvailableBidTokensBySize((Context)GlobalTradPlus.getInstance().getContext(), (int)100);
        }
        return "";
    }
}

