/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.vungle;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.vungle.VungleErrorUtil;
import com.tradplus.ads.vungle.VungleInitManager;
import com.tradplus.ads.vungle.VungleInterstitialCallbackRouter;
import com.vungle.warren.AdConfig;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleInterstitial
extends TPInterstitialAdapter {
    private static final String TAG = "VungleInterstitial";
    private String payload;
    private VungleInterstitialCallbackRouter mRouter;
    private String placementId;
    private String appId;
    private Map<String, Object> localExtras;
    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback(){

        public void onAdLoad(String placementReferenceID) {
            VungleInterstitial.this.setFirstLoadedTime();
            Log.i((String)VungleInterstitial.TAG, (String)"onAdLoad: ");
            if (VungleInterstitial.this.mRouter.getListener(placementReferenceID) != null) {
                VungleInterstitial.this.mRouter.getListener(placementReferenceID).loadAdapterLoaded(null);
            }
        }

        public void onError(String id, VungleException exception) {
            Log.i((String)VungleInterstitial.TAG, (String)("onError: " + exception.getLocalizedMessage()));
            if (VungleInterstitial.this.mRouter.getListener(id) != null) {
                VungleInterstitial.this.mRouter.getListener(id).loadAdapterLoadFailed(VungleErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", (Throwable)exception));
            }
        }
    };
    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback(){

        public void creativeId(String s) {
        }

        public void onAdStart(String placementReferenceID) {
            Log.i((String)VungleInterstitial.TAG, (String)"onAdStart: ");
            if (VungleInterstitial.this.mRouter.getShowListener(placementReferenceID) != null) {
                VungleInterstitial.this.mRouter.getShowListener(placementReferenceID).onAdShown();
            }
        }

        public void onAdEnd(String placementReferenceID, boolean completed, boolean isCTAClicked) {
            Log.i((String)VungleInterstitial.TAG, (String)"onAdEnd: ");
        }

        public void onAdEnd(String id) {
            Log.i((String)VungleInterstitial.TAG, (String)"onAdEnd: ");
            if (VungleInterstitial.this.mRouter.getShowListener(id) != null) {
                VungleInterstitial.this.mRouter.getShowListener(id).onAdClosed();
            }
        }

        public void onAdClick(String id) {
            Log.i((String)VungleInterstitial.TAG, (String)"onAdClick: ");
            if (VungleInterstitial.this.mRouter.getShowListener(id) != null) {
                VungleInterstitial.this.mRouter.getShowListener(id).onAdClicked();
            }
        }

        public void onAdRewarded(String id) {
        }

        public void onAdLeftApplication(String id) {
        }

        public void onError(String id, VungleException exception) {
            Log.i((String)VungleInterstitial.TAG, (String)("onError: " + exception.getLocalizedMessage()));
            if (VungleInterstitial.this.mRouter.getShowListener(id) != null) {
                VungleInterstitial.this.mRouter.getShowListener(id).onAdVideoError(VungleErrorUtil.getTradPlusErrorCode("Didn't find valid adv.Show Failed", (Throwable)exception));
            }
        }

        public void onAdViewed(String id) {
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.localExtras = localExtras;
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appId = serverExtras.get("appId");
        this.placementId = serverExtras.get("placementId");
        this.payload = serverExtras.get("Bidding-Payload");
        this.mRouter = VungleInterstitialCallbackRouter.getInstance();
        this.mRouter.addListener(this.placementId, this.mLoadAdapterListener);
        VungleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                VungleInterstitial.this.VungleLoadAd();
            }

            public void onFailed(String code, String msg) {
                if (VungleInterstitial.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    VungleInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void VungleLoadAd() {
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            Vungle.loadAd((String)this.placementId, (LoadAdCallback)this.vungleLoadAdCallback);
        } else {
            Vungle.loadAd((String)this.placementId, (String)this.payload, (AdConfig)this.getAdConfig(), (LoadAdCallback)this.vungleLoadAdCallback);
        }
    }

    private AdConfig getAdConfig() {
        AdConfig adConfig = new AdConfig();
        adConfig.setBackButtonImmediatelyEnabled(true);
        adConfig.setMuted(true);
        adConfig.setOrdinal(1);
        return adConfig;
    }

    public boolean isReady() {
        if (this.placementId == null) {
            return !this.isAdsTimeOut();
        }
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            return !this.isAdsTimeOut() && Vungle.canPlayAd((String)this.placementId, (String)this.payload);
        }
        return !this.isAdsTimeOut() && Vungle.canPlayAd((String)this.placementId);
    }

    public void showAd() {
        if (this.mRouter != null && this.mShowListener != null) {
            this.mRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if (!Vungle.isInitialized()) {
            this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Third-party network SDK failed to init"));
            return;
        }
        if (this.mRouter.getShowListener(this.placementId) == null) {
            this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            Log.i((String)TAG, (String)("showAd payload : " + this.payload));
            if (!Vungle.canPlayAd((String)this.placementId, (String)this.payload)) {
                this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                return;
            }
            Vungle.playAd((String)this.placementId, (String)this.payload, (AdConfig)this.getAdConfig(), (PlayAdCallback)this.vunglePlayAdCallback);
        } else {
            if (!Vungle.canPlayAd((String)this.placementId)) {
                this.mRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                return;
            }
            Vungle.playAd((String)this.placementId, (AdConfig)this.getAdConfig(), (PlayAdCallback)this.vunglePlayAdCallback);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("7");
    }

    public String getNetworkVersion() {
        return "6.11.0";
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams) {
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return "";
        }
        this.appId = tpParams.get("appId");
        this.placementId = tpParams.get("placementId");
        if (GlobalTradPlus.getInstance().getContext() != null && !TextUtils.isEmpty((CharSequence)this.appId)) {
            VungleInitManager.getInstance().initSDK(context, this.localExtras, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                }

                public void onFailed(String code, String msg) {
                }
            });
            return Vungle.getAvailableBidTokensBySize((Context)GlobalTradPlus.getInstance().getContext(), (int)100);
        }
        return "";
    }
}

